<div class="xts-dashboard">

    <?php if ( woodmart_get_opt( 'white_label' ) ) : ?>
        <section class="xts-card xts-theme">
            <header class="xts-card-header">
                <h2>
                    <?php echo esc_html( woodmart_get_opt( 'white_label_dashboard_title' ) ?: __( 'وودمـــارت', 'woodmart' ) ); ?>
                </h2>
            </header>
            <div class="xts-card-body">
                <p>
                    <?php echo wp_kses( woodmart_get_opt( 'white_label_dashboard_text' ) ?: __( 'از شما بابت خرید قالب جت وودمارت متشکریم.', 'woodmart' ), true ); ?>
                </p>
            </div>
        </section>

    <?php else : ?>
        <section class="xts-card xts-theme-light">
            <div class="xts-card-banner">
            </div>
            <div class="xts-card-body">
                <h2><?php esc_html_e( 'وودمـــارت', 'woodmart' ); ?></h2>
                <p><?php esc_html_e( 'از شما بابت خرید قالب جت وودمارت متشکریم.', 'woodmart' ); ?></p>
                <?php if ( woodmart_get_opt( 'white_label_changelog_tab' ) ) : ?>
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=xts_changelog' ) ); ?>" class="xts-btn-primary">
                        <?php esc_html_e( 'جت وودمارت', 'woodmart' ); ?>
                    </a>
                <?php endif; ?>
            </div>
        </section>

        <div class="xts-grid">
            <section class="xts-card">
                <header class="xts-card-header">
                    <h3><?php esc_html_e( 'نیاز به کمک دارید؟', 'woodmart' ); ?></h3>
                    <p><?php esc_html_e( 'از لینک‌های زیر استفاده کنید.', 'woodmart' ); ?></p>
                </header>
                <div class="xts-card-links">
                    <?php 
                        $help_links = [
                            [ 'img' => 'docs.jpg', 'text' => 'Documentation', 'url' => 'https://elementorjet.ir' ],
                            [ 'img' => 'video.jpg', 'text' => 'Video tutorials', 'url' => 'https://elementorjet.ir' ],
                            [ 'img' => 'forum.jpg', 'text' => 'Support forum', 'url' => 'https://elementorjet.ir' ]
                        ];
                        foreach ( $help_links as $link ) : ?>
                        <a href="<?php echo esc_url( $link['url'] ); ?>" target="_blank" class="xts-link-card">
                            <img src="<?php echo esc_url( WOODMART_ASSETS_IMAGES . '/dashboard/' . $link['img'] ); ?>" alt="<?php echo esc_attr( $link['text'] ); ?>">
                            </br>
                            <span><?php esc_html_e( $link['text'], 'woodmart' ); ?></span>
                        </a>
                    <?php endforeach; ?>
                </div>
            </section>

            <section class="xts-card xts-center">
                <header class="xts-card-header">
                    <h3><?php esc_html_e( 'از محصول ما راضی هستید؟', 'woodmart' ); ?></h3>
                </header>
                <div class="xts-card-body">
                    <p><?php esc_html_e( 'در نظرسنجی ما شرکت کنید و تجربه‌تان را با دیگران به اشتراک بگذارید.', 'woodmart' ); ?></p>
                    <a href="https://elementorjet.ir/product/woodmart-theme/" target="_blank" class="xts-btn-primary">
                        <?php esc_html_e( 'شرکت در نظرسنجی', 'woodmart' ); ?>
                    </a>
                </div>
            </section>
        </div>
    <?php endif; ?>

</div>



<style>
/* ساختار کلی داشبورد */
.xts-dashboard {
    padding: 20px;
    background: #f4f6f9;
}

/* کارت‌ها */
.xts-card {
    background: #fff;
    border-radius: 14px;
    overflow: hidden;
    margin-bottom: 20px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.06);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.xts-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 18px rgba(0,0,0,0.1);
}

/* هدر کارت‌ها - آبی */
.xts-card-header {
    background: #2196F3;
    color: #fff;
    padding: 16px;
    border-bottom: 2px solid #1565C0;
}

.xts-card-header h2,
.xts-card-header h3 {
    margin: 0;
    font-size: 1.1rem;
}

/* محتوای کارت */
.xts-card-body {
    padding: 16px;
    color: #333; /* چون بک‌گراند روشنه متن تیره */
    line-height: 1.6;
}

/* کارت‌های با بک‌گراند تیره - متن سفید */
.xts-card.dark {
    background: #1565C0;
    color: #fff;
}

.xts-card.dark .xts-card-body {
    color: #fff;
}

/* بنر کارت */
.xts-card-banner img {
    width: 100%;
    display: block;
}

/* لینک‌های کمکی - زرد */
.xts-card-links {
    display: flex;
    gap: 12px;
    flex-wrap: wrap;
    padding: 16px;
}

.xts-link-card {
    flex: 1 1 calc(33.33% - 10px);
    background: #fff8e1;
    border: 2px solid #FFC107;
    border-radius: 10px;
    text-align: center;
    padding: 12px;
    transition: all 0.3s ease;
    text-decoration: none;
    color: #222;
}

.xts-link-card img {
    max-width: 100%;
    border-radius: 8px;
    margin-bottom: 8px;
}

.xts-link-card:hover {
    background: #ffecb3;
    transform: scale(1.03);
}

/* دکمه‌ها - زرد */
.xts-btn-primary {
    display: inline-block;
    padding: 10px 20px;
    background: #FFC107;
    color: #000; /* چون بک‌گراند روشنه متن تیره */
    border-radius: 8px;
    text-decoration: none;
    font-weight: bold;
    border: 2px solid #FFA000;
    transition: all 0.3s ease;
}

.xts-card-header h3{
    color:#fff;
}

.xts-btn-primary:hover {
    background: #FFA000;
    border-color: #FF8F00;
    color: #000;
}

/* گرید */
.xts-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 20px;
}

/* مرکزچین */
.xts-center {
    text-align: center;
}

    
</style>