<?php




if (!class_exists('siba_Dashboard_Widget')) {
    class siba_Dashboard_Widget {
        public function __construct() {
            add_action('admin_init', [$this, 'add_dashboard_widget']);
            add_action('wp_ajax_siba_dashboard_widgets', [$this, 'ajax_dashboard_widgets']);
            add_action('wp_ajax_nopriv_siba_dashboard_widgets', [$this, 'ajax_dashboard_widgets']);
            add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_dashboard_assets']);
        }
        public function add_dashboard_widget() {
            add_meta_box(
                'siba_Dashboard_Widget',
                __('سیبا شاپ'),
                [$this, 'dashboard_widget_content'],
                'dashboard',
                'normal',
                'high'
            );
        }

        public function dashboard_widget_content() {
            ?>
            <div class="dashboard-widget-content2">
                
                <div style=" direction: ltr; ">
                    <button class="slider-button2 prev" onclick="moveToPreviousSlide2()">&#10094;</button>
                    <button class="slider-button2 next" onclick="moveToNextSlide2()">&#10095;</button>
                </div>
                <div id="sponsorship_slider2" class="slider" style="align-items: center;">
                    <div id="loading-message2" class="loading2" style=" width: 100%; ">
                        <div class="loader2">SIBA SHOP</div>
                    </div>
                </div>
            </div>

            <div class="dashboard-widget-content2">
                <div style=" display: flex; ">
                    <span class="dashicons dashicons-welcome-learn-more" style=" color: #FBBC34; "></span>
                    <h3 style="padding-right: 6px; font-weight: 900;"><?php esc_html_e('راهنمای خرید', 'siba-dashboard'); ?></h3>
                </div>
                <ul style=" margin: 0; ">
                <?php
                    $feed_url = 'https://sibashop.com/siba-feed/knowledge-feed.xml';
                    $response = wp_remote_get($feed_url);
                    if (is_wp_error($response)){
                        echo '<p>' . esc_html__('خطا در بارگزاری آموزش‌های جدید', 'siba-dashboard') . '</p>';
                        return;
                    }
                    $body = wp_remote_retrieve_body($response);
                    $rss = simplexml_load_string($body);
                    if ($rss === false){
                        echo '<p>' . esc_html__('خطا در دریافت آموزش‌ها', 'siba-dashboard') . '</p>';
                        return;
                    }
                    foreach ($rss->channel->item as $item){
                        $title = esc_html($item->title);
                        $link = esc_url($item->link);
                        echo "<li><a href='{$link}' target='_blank'>{$title}</a></li>";
                    }
                ?>
                </ul>
            </div>

            <hr width="100%" style=" margin-top: 14px; margin-bottom: 14px; "/>

            <div class="dashboard-widget-content2">
                <div style=" display: flex; ">
                    <span class="dashicons dashicons-rss" style=" color: #FBBC34; "></span>
                    <h3 style="padding-right: 6px; font-weight: 900;"><?php esc_html_e('آخرین اخبار سیباشاپ', 'siba-dashboard'); ?></h3>
                </div>
                <ul style=" margin: 0; ">
                <?php
                    $feed_url = 'https://sibashop.com/siba-feed/news-feed.xml';
                    $response = wp_remote_get($feed_url);
                    if (is_wp_error($response)){
                        echo '<p>' . esc_html__('خطا در بارگزاری اخبار جدید', 'siba-dashboard') . '</p>';
                        return;
                    }
                    $body = wp_remote_retrieve_body($response);
                    $rss = simplexml_load_string($body);
                    if ($rss === false){
                        echo '<p>' . esc_html__('خطا در دریافت اخبار', 'siba-dashboard') . '</p>';
                        return;
                    }
                    foreach ($rss->channel->item as $item){
                        $title = esc_html($item->title);
                        $link = esc_url($item->link);
                        echo "<li><a href='{$link}' target='_blank'>{$title}</a></li>";
                    }
                ?>
                </ul>
            </div>

            <p class="community-events-footer">
                <?php
                    printf(
                        '<a style=" font-size: 11px; " href="https://sibashop.com/shop/" target="_blank">%2$s <span class="screen-reader-text"> %3$s</span><span aria-hidden="true" class="dashicons dashicons-external"></span></a>',
                        'https://sibashop.com/shop/',
                        __('جشنواره‌های فروش'),
                        __('(opens in a new tab)')
                    );
                ?>

                |

                <?php
                    printf(
                        '<a href="%1$s" target="_blank">%2$s <span class="screen-reader-text"> %3$s</span><span aria-hidden="true" class="dashicons dashicons-external"></span></a>',
                        'https://sibashop.com/product-category/shop-equipment/',
                        __('تجهیزات فروشگاهی'),
                        __('(opens in a new tab)')
                    );
                ?>

                |

                <?php
                    printf(
                        '<a href="%1$s" target="_blank">%2$s <span class="screen-reader-text"> %3$s</span><span aria-hidden="true" class="dashicons dashicons-external"></span></a>',
                        esc_url(_x('https://sibaclub.com/', 'Sponsership plans')),
                        __('نرم‌افزار حسابداری'),
                        __('(opens in a new tab)')
                    );
                ?>
            </p>

            <style>
                .slider {
                    display: flex;
                    position: relative;
                    width: 100%;
                    height: 300px;
                    max-height: 300px;
                }

                .slide2 {
                    min-width: 100%;
                    height: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    transition: transform 0.5s ease;
                }

                .slide2 img {
                    max-width: 100%;
                    max-height: 100%;
                    object-fit: contain;
                    border-radius: 8px;
                }

                .slider-button2 {
                    border-radius: 12px;
                    position: absolute;
                    top: 30%;
                    transform: translateY(-50%);
                    background-color: rgba(0, 0, 0, 0.5);
                    color: white;
                    border: none;
                    padding: 10px;
                    font-size: 20px;
                    cursor: pointer;
                    z-index: 10;
                }

                .prev {
                    left: 10px;
                }

                .next {
                    right: 10px;
                }

                .slider-button2:hover {
                    background-color: rgba(0, 0, 0, 0.8);
                }
                
                .slider {
                    display: flex;
                    position: relative;
                    width: 100%;
                    height: 300px;
                    max-height: 300px;
                }
                .dashboard-widget-content2{
                    overflow: hidden;
                }

                .slide2 {
                    min-width: 100%;
                    height: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    transition: transform 0.5s ease;
                }

                .slide2 img {
                    max-width: 100%;
                    max-height: 100%;
                    object-fit: contain;
                    border-radius: 8px;
                    background: none !important; 
                }

                #sponsorship-guide {
                    margin-bottom: 20px;
                }

                #sponsorship-guide .question {
                    font-size: 16px;
                    margin-bottom: 10px;
                }

                #sponsorship-guide ul {
                    list-style: none;
                    padding: 0;
                }

                #sponsorship-guide ul li {
                    margin: 5px 0;
                }

                #sponsorship-guide ul li a {
                    text-decoration: none;
                    color: #0073aa;
                }

                #sponsorship-guide ul li a:hover {
                    color: #005177;
                }

                .loading2 {
                    font-size: 18px;
                    text-align: center;
                    margin-top: 20px;
                    justify-content: center;
                    align-items: center;
                    display: block;
                }

                @keyframes animate8345 {
                    0%, 100% {
                        filter: hue-rotate(0deg);
                    }
                    50% {
                        filter: hue-rotate(360deg);
                    }
                }

                .loader2 {
                    color: rgb(0, 0, 0);
                    background: linear-gradient(to right, #1694E4, #FBBC34);
                    font-size: 30px;
                    -webkit-text-fill-color: transparent;
                    -webkit-background-clip: text;
                    animation: animate8345 9s linear infinite;
                    font-weight: bold;
                }
            </style>

            <script>
                let currentIndex2 = 0;

                function moveToNextSlide2() {
                    const sliderContainer2 = document.getElementById('sponsorship_slider2');
                    const slides2 = document.querySelectorAll('.slide2');
                    const totalSlides2 = slides2.length;

                    currentIndex2 = (currentIndex2 + 1) % totalSlides2;
                    sliderContainer2.style.transform = `translateX(${currentIndex2 * 100}%)`;
                }

                function moveToPreviousSlide2() {
                    const sliderContainer2 = document.getElementById('sponsorship_slider2');
                    const slides2 = document.querySelectorAll('.slide2');
                    const totalSlides2 = slides2.length;

                    currentIndex2 = (currentIndex2 - 1 + totalSlides2) % totalSlides2;
                    sliderContainer2.style.transform = `translateX(${currentIndex2 * 100}%)`;
                }

                document.addEventListener('DOMContentLoaded', function () {
                    const loadingMessage2 = document.getElementById('loading-message2');
                    const sliderContainer2 = document.getElementById('sponsorship_slider2');
                    sliderContainer2.style.visibility = 'visible'; // Show slider once it's loaded

                    jQuery.ajax({
                        url: ajaxurl,
                        method: 'GET',
                        data: { action: 'load_sponsors2' },
                        success: function(response) {
                            const sponsors3 = JSON.parse(response);  // Parse as JSON
                            loadingMessage2.style.display = 'none'; // Hide loading message

                            if (sponsors3.error) {
                                alert(sponsors3.error);
                                return;
                            }

                            if (sponsors3.length === 0) {
                                sliderContainer2.innerHTML = '<p>هیچ اطلاعاتی برای بارگذاری وجود ندارد</p>';
                                return;
                            }

                            sponsors3.forEach(sponsor => {
                                const slide2 = document.createElement('div');
                                slide2.classList.add('slide2');
                                slide2.innerHTML = `
                                    <a href="${sponsor.link}" target="_blank">
                                        <img src="${sponsor.image_url}" alt="${sponsor.image_alt}">
                                    </a>
                                `;
                                sliderContainer2.appendChild(slide2);
                            });

                            let autoSlideInterval = setInterval(moveToNextSlide2, 5000);
                        },
                        error: function() {
                            alert('Failed to load sponsors');
                        }
                    });
                });
            </script>
            <?php
        }

        public function ajax_dashboard_widgets() {
            if (isset($_GET['widget']) && $_GET['widget'] === 'siba_Dashboard_Widget') {
                $this->dashboard_widget_content();
            }
            wp_die();
        }

        public function enqueue_admin_dashboard_assets($hook) {
            if ($hook !== 'index.php') {
                return;
            }

            wp_localize_script('siba-dashboard-script', 'ajaxurl', admin_url('admin-ajax.php'));
        }
    }

    if (!defined('siba_DASHBOARD_WIDGET_LOADED')) {
        define('siba_DASHBOARD_WIDGET_LOADED', true);
        new siba_Dashboard_Widget();
    }
}

add_action('wp_ajax_load_sponsors2', 'load_sponsors_from_apis22');
add_action('wp_ajax_nopriv_load_sponsors2', 'load_sponsors_from_apis22');

if (!function_exists('load_sponsors_from_apis22')) {
    function load_sponsors_from_apis22() {
        $feed_url2 = 'https://sibashop.com/siba-feed/sponsors.txt';
        $response2 = wp_remote_get($feed_url2);

        if (is_wp_error($response2)) {
            echo json_encode(['error' => 'Failed to load sponsors']);
            wp_die();
        }

        $sponsors2 = json_decode(wp_remote_retrieve_body($response2), true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            echo json_encode(['error' => 'Invalid JSON format']);
            wp_die();
        }

        echo json_encode($sponsors2);
        wp_die();
    }
}
?>