<?php

add_action( 'wp_enqueue_scripts', 'woodmart_child_enqueue_styles', 1000 );

function woodmart_child_enqueue_styles() {
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'woodmart-style' ), woodmart_get_theme_info( 'Version' ) );
}

/**
 * Function to return new placeholder image URL.
 */
function woocommerce_ir_custom_woocommerce_placeholder( $image_url ) {
  $image_url = 'http://ghztools.ir/wp-content/uploads/2024/11/27002-scaled-1.jpg'; 
  return $image_url;
}
/**
 * حذف لوگو   
 */
add_action( 'wp_before_admin_bar_render', function () {
	global $wp_admin_bar;
	$wp_admin_bar->remove_menu( 'wp-logo' );
}, 0 );
/**
* انتقال محصولات ناموجود به انتهای لیست فروشگاه   
 */
function move_out_of_stock_to_end( $query ) {
if ( ! is_admin() && $query->is_main_query() && ( is_shop() || is_product_category() || is_product_tag() ) ) {
$meta_query = $query->get('meta_query');
if ( ! $meta_query ) {
$meta_query = array();
}
$meta_query[] = array(
'relation' => 'OR',
array(
'key' => '_stock_status',
'value' => 'instock',
'compare' => 'IN'
),
array(
'key' => '_stock_status',
'value' => 'outofstock',
'compare' => 'IN'
)
);
$query->set('meta_query', $meta_query);
$query->set('orderby', array( 'meta_value' => 'ASC' ));
}
}
add_action( 'pre_get_posts', 'move_out_of_stock_to_end' );
/**
 *   Custom Dashboard Widget
 */
// افزودن ویجت سفارشی به داشبورد وردپرس
add_action('wp_dashboard_setup', 'my_custom_dashboard_widgets');
  
function my_custom_dashboard_widgets() {
    global $wp_meta_boxes;
    
    // افزودن ویجت به داشبورد
    wp_add_dashboard_widget('custom_help_widget', 'قالب فروشگاهی گروه طراحی وب سیبا ', 'custom_dashboard_help');
}

// تولید محتوای ویجت سفارشی
function custom_dashboard_help() {
    echo '<p>از اینکه سیبا را انتخاب کردید، بسیار سپاسگزاریم. 
	<br>sibaclub.com
	<br></p>';
}
// غیرفعال سازی گوتنبرگ برای نوشته ها
add_filter('use_block_editor_for_post', '__return_false', 10);
// غیرفعال کردن گوتنبرگ برای ابزارک ها
add_filter('use_widgets_block_editor', '__return_false');

// [حذف ویجت جت]
function ejet_dashboard_widget_default_hidden($user_id) {
    // دریافت مقدار ذخیره‌شده در متاباکس
    $hidden = get_user_meta($user_id, 'metaboxhidden_dashboard', true);
    
    // دریافت متای سفارشی که نشان دهد آیا قبلاً مقدار تنظیم شده است یا نه
    $is_initialized = get_user_meta($user_id, 'ejet_widget_hidden_initialized', true);

    // اگر مقدار از قبل تنظیم نشده، مقدار دهی اولیه انجام شود
    if (!$is_initialized) {
        // اگر متاباکس وجود ندارد یا فرمت آن صحیح نیست، مقدار اولیه تعیین شود
        if (!is_array($hidden)) {
            $hidden = [];
        }

        // اضافه کردن ویجت به لیست مخفی (در اولین اجرا)
        if (!in_array('elementorjet_Dashboard_Widget', $hidden)) {
            $hidden[] = 'elementorjet_Dashboard_Widget';
            update_user_meta($user_id, 'metaboxhidden_dashboard', $hidden);
        }

        // تنظیم متای سفارشی برای جلوگیری از تغییر مجدد در آینده
        update_user_meta($user_id, 'ejet_widget_hidden_initialized', 1);
    }
}

// اجرای تابع برای کاربران فعلی
add_action('admin_init', function () {
    $current_user = wp_get_current_user();
    if ($current_user->ID) {
        ejet_dashboard_widget_default_hidden($current_user->ID);
    }
});

// اجرای تابع برای کاربران جدید


// [افزودن ویجت سیبا]
if ( is_user_logged_in() ) {
    if ( current_user_can('administrator') ) {
        add_action('user_register', 'ejet_dashboard_widget_default_hidden');
        add_action('user_register', 'ejet_dashboard_widget_hidden_once');
    }
}

require 'siba/siba.php';
/**
 * کد  درست کردن لودینگ المنتور
 */
 function elementor_load_elements()  { ?>
<style>
body.elementor-panel-loading #elementor-panel-state-loading { display: none !important; }
</style>
<?php }
add_action('elementor/editor/before_enqueue_scripts', 'elementor_load_elements');

/**
 افزودن سرچ در دسته بندی صفحه محصولات
 */
function custom_admin_product_category_search_box() {
    $screen = get_current_screen();
    if ( $screen && $screen->post_type === 'product' ) {
        ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const categoryBox = document.querySelector('#product_cat-all');
                if (!categoryBox) return;

                // ایجاد فیلد جستجو
                const searchInput = document.createElement('input');
                searchInput.type = 'text';
                searchInput.placeholder = 'جستجو...';
                searchInput.style.width = '100%';
                searchInput.style.marginBottom = '8px';
                searchInput.style.marginTop = '15px';

                categoryBox.prepend(searchInput);

                searchInput.addEventListener('input', function () {
                    const filter = this.value.toLowerCase();
                    const items = categoryBox.querySelectorAll('li');

                    items.forEach(function (item) {
                        const label = item.textContent.toLowerCase();
                        item.style.display = label.includes(filter) ? '' : 'none';
                    });
                });
            });
        </script>
        <?php
    }
}
add_action('admin_footer-post.php', 'custom_admin_product_category_search_box');
add_action('admin_footer-post-new.php', 'custom_admin_product_category_search_box');

add_shortcode('end_of_today', function() {
    $now = new DateTime('now', wp_timezone());
    $now->setTime(23, 59, 59);
    return $now->format('Y-m-d H:i:s');
});

function daily_countdown_shortcode() {
    // ایجاد یک شناسه یکتا برای هر بار استفاده
    $uid = uniqid('daily_countdown_');

    ob_start();
    ?>
    <div id="<?php echo esc_attr($uid); ?>" style="color: var(--e-global-color-48a7605); font-size: 14px;  direction:rtl;">--:--:--</div>
    <script>
    document.addEventListener("DOMContentLoaded", function () {
        const countdownEl = document.getElementById('<?php echo esc_js($uid); ?>');
        function updateCountdown_<?php echo esc_js($uid); ?>() {
            const now = new Date();
            const end = new Date();
            end.setHours(23, 59, 59, 999);

            const diff = end - now;
            if (diff <= 0) {
                countdownEl.innerText = "00:00:00";
                return;
            }

            const hours = String(Math.floor(diff / (1000 * 60 * 60))).padStart(2, '0');
            const minutes = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60))).padStart(2, '0');
            const seconds = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2, '0');

            countdownEl.innerText = `${hours}:${minutes}:${seconds}`;
        }

        updateCountdown_<?php echo esc_js($uid); ?>();
        setInterval(updateCountdown_<?php echo esc_js($uid); ?>, 1000);
    });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('daily_countdown', 'daily_countdown_shortcode');





function shortcode_product_features_boxes() {
    if (!is_product()) return '';

    global $product;

    $max_features = 6;

    $attributes = $product->get_attributes();

    $output = '<div class="custom-feature-boxes">';

    $count = 0;

    foreach ($attributes as $attribute) {
        if ($count >= $max_features) break;

        $name = wc_attribute_label($attribute->get_name());
        $value = $product->get_attribute($attribute->get_name());

        if (!empty($value)) {
            $output .= '<div class="feature-box"><strong class="feature-box-st" style=" color: #1b1b1b; ">' . esc_html($name) . ':</strong> ' . '<p class="feature-box-p" style="     margin-bottom: 0; ">' .esc_html($value) .'</p>' .'</div>';
            $count++;
        }
    }

    $output .= '</div>';

    $output .= '<style>
    .custom-feature-boxes {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-top: 20px;
    }
    .feature-box {
        background-color: #F9FAFB;
        border-radius: 10px;
        padding: 12px 16px;
        text-align: right;
        font-weight: 500;
        flex: 1 1 100%;
    }
    </style>';

    return $output;
}
add_shortcode('product_features_boxes', 'shortcode_product_features_boxes');



function product_dynamic_notice_shortcode() {
    ob_start();

	$post = get_post();
	$post_id = $post->ID;
	$product = wc_get_product( $post_id );
	
	$stock_quantity = get_post_meta( $post_id, '_stock', true );
		if (!$stock_quantity){
			$stock_quantity = 11;	
		}
	$sales = get_post_meta( $post_id, 'total_sales', true );
// 	if ($sales == 0){
// 		$sales = rand(1, 4);
// 	}
// 	else if ($sales < 6 ){
// 		$sales = $sales *2;
// 	}

	
    $views = rand(10, 30);
    
;

    ?>
    <style>
        #dynamic-product-message {
            overflow: hidden;
            height: 24px;
            position: relative;
        }

        #product-message-content {
            display: inline-block;
            transition: transform 0.4s ease, opacity 0.4s ease;
            will-change: transform, opacity;
        }

        .scroll-out {
            transform: translateY(-100%);
            opacity: 0;
        }

        .scroll-in {
            transform: translateY(100%);
            opacity: 0;
        }

        .scroll-reset {
            transform: translateY(0%);
            opacity: 1;
        }
    </style>

    <div id="dynamic-product-message">
        <span id="product-message-content"> </span>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const messages = [
				<?php if ( $stock_quantity < 10 ) : ?>
					"🔥 تنها <?php echo $stock_quantity; ?> عدد در انبار باقی مانده",
				<?php endif; ?>
                "👀 +<?php echo $views; ?> بازدید در ۲۴ ساعت اخیر",
				"🛒 <?php echo $sales; ?> فروش در هفته گذشته"
			];

            let index = 0;
            const msgEl = document.getElementById("product-message-content");

            function changeMessage() {
                msgEl.classList.remove('scroll-reset');
                msgEl.classList.add('scroll-out');

                setTimeout(() => {
                    msgEl.textContent = messages[index];
                    index = (index + 1) % messages.length;

                    msgEl.classList.remove('scroll-out');
                    msgEl.classList.add('scroll-in');

                    setTimeout(() => {
                        msgEl.classList.remove('scroll-in');
                        msgEl.classList.add('scroll-reset');
                    }, 50);
                }, 400);
            }

            changeMessage();
            setInterval(changeMessage, 4000);
        });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('dynamic_product_notice', 'product_dynamic_notice_shortcode');
/**
 * حذف خودکار تصویر شاخص و گالری محصول ووکامرس فقط در صورت عدم استفاده در سایر محصولات
 */
add_action( 'before_delete_post', function( $post_id ) {
    // فقط برای محصولات
    if ( get_post_type( $post_id ) !== 'product' ) {
        return;
    }

    // جمع‌آوری تمام ID های تصاویر مرتبط با محصول
    $image_ids = [];

    // تصویر شاخص
    $thumbnail_id = get_post_thumbnail_id( $post_id );
    if ( $thumbnail_id ) {
        $image_ids[] = $thumbnail_id;
    }

    // گالری تصاویر
    $gallery_ids = get_post_meta( $post_id, '_product_image_gallery', true );
    if ( ! empty( $gallery_ids ) ) {
        $gallery_ids = explode( ',', $gallery_ids );
        $image_ids = array_merge( $image_ids, $gallery_ids );
    }

    // حذف امن تصاویر در صورت عدم استفاده در سایر محصولات
    foreach ( $image_ids as $image_id ) {
        $image_id = (int) $image_id;

        // بررسی در محصولات دیگر
        $used_elsewhere = new WP_Query([
            'post_type'      => 'product',
            'post_status'    => 'any',
            'posts_per_page' => 1,
            'post__not_in'   => [ $post_id ],
            'meta_query'     => [
                'relation' => 'OR',
                [
                    'key'     => '_thumbnail_id',
                    'value'   => $image_id,
                    'compare' => '='
                ],
                [
                    'key'     => '_product_image_gallery',
                    'value'   => $image_id,
                    'compare' => 'LIKE'
                ]
            ]
        ]);

        // اگر در جای دیگری استفاده نشده، حذف کن
        if ( ! $used_elsewhere->have_posts() ) {
            wp_delete_attachment( $image_id, true );
        }

        wp_reset_postdata();
    }

    // متادیتای گالری را هم پاک کن
    delete_post_meta( $post_id, '_product_image_gallery' );

}, 10, 1 );




// افزودن فیلد در صفحه ویرایش محصول
add_action( 'woocommerce_product_options_general_product_data', 'add_english_name_field_to_products' );
function add_english_name_field_to_products() {
    woocommerce_wp_text_input( array(
        'id'          => '_english_name',
        'label'       => 'نام انگلیسی محصول',
        'placeholder' => 'English product name...',
        'desc_tip'    => true,
        'description' => 'در این قسمت نام انگلیسی محصول را وارد کنید.',
    ) );
}

// ذخیره‌سازی مقدار فیلد
add_action( 'woocommerce_admin_process_product_object', 'save_english_name_field_to_product' );
function save_english_name_field_to_product( $product ) {
    if ( isset( $_POST['_english_name'] ) ) {
        $product->update_meta_data( '_english_name', sanitize_text_field( $_POST['_english_name'] ) );
    }
}



// ایجاد شورت‌کد برای نمایش نام انگلیسی محصول
add_shortcode( 'english_name', 'get_product_english_name_shortcode' );

function get_product_english_name_shortcode( $atts ) {
    global $post;

    // بررسی اینکه آیا در صفحه محصول هستیم یا خیر
    if ( ! $post || 'product' !== get_post_type( $post ) ) {
        return '';
    }

    $english_name = get_post_meta( $post->ID, '_english_name', true );

    if ( ! empty( $english_name ) ) {
        return esc_html( $english_name );
    }

    return ''; // در صورت خالی بودن مقدار
}




// /**
// /**       Block HTTP Request
// /**  در شرایطی که اینترنت ملی شده باشد این قطعه کد فعال شود
//  */
// add_filter('pre_http_request', function ($pre, $args, $url) {
//     if (is_admin()) {
//         return new WP_Error('http_blocked', 'HTTP requests are blocked in admin.');
//     }
//     return $pre;
// }, 10, 3);

