<?php

function SIBA_sms_verify() {
    $result = [
        'message' => 'خطا در ارسال پیامک'
    ];

    // بررسی فیلدهای ورودی
    if( 
        ! isset($_REQUEST['phone']) ||
        ! isset($_REQUEST['code'])
    ) {
        wp_send_json_error($result, 401);
    }

    // پاکسازی شماره تلفن
    $phone = sanitize_phone($_REQUEST['phone']);
    
    if(! $phone) {
        $result['message'] = 'شماره تلفن واردشده، صحیح نمی‌باشد.';
        wp_send_json_error($result, 401);
    }

    // پاکسازی کد
    $code = sanitize_text_field($_REQUEST['code']);

    // بررسی وجود شماره و کد تأیید در پایگاه داده
    global $wpdb;
    $verify = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT * FROM {$wpdb->SIBA_sms_login} WHERE phone = %s ORDER BY created_at DESC",
            $phone
        )
    );


            if(! $verify ){
                
                $result['message'] = 'خطا در درخواست احراز هویت';
                wp_send_json_error($result, 401);
            }



            if( current_time( 'timestamp' ) >= strtotime( $verify->expired_at ) ){
                $result['message'] = 'کد وارد شده منقضی شده است مجدداً تلاش کنید';
                wp_send_json_error($result, 401);
            }

    // محدودیت وارد کردن کد تایید 3 بار
    if ($verify->attempts >= 3) {
        $result['message'] = 'تعداد تلاش‌ های شما بیش از حد مجاز است. لطفا بعدا تلاش کنید.';
        wp_send_json_error($result, 401);
    }

    // چک کن اگه کد وارد شده اشتباهه
    if ($verify->code != $code) {
        // افزایش مقدار تلاش ها در دیتابیس
        $wpdb->update(
            $wpdb->SIBA_sms_login,
            ['attempts' => $verify->attempts + 1],
            ['ID' => $verify->ID]
        );

        $result['message'] = 'کد وارد شده اشتباه است، مجدداً تلاش کنید.';
        wp_send_json_error($result, 401);
    }

    // ریست کردن تعداد تلاش ها
    $wpdb->update(
        $wpdb->SIBA_sms_login,
        ['attempts' => 0],
        ['ID' => $verify->ID]
    );

            $exists  = SIBA_get_user_by_phone( $phone );


            $user    = SIBA_get_or_make_user( $phone );

            if( is_wp_error( $user ) ){
                $result['message'] = $user->get_error_message();
                wp_send_json_error($result, 401);
            }

            wp_clear_auth_cookie();
            wp_set_current_user( $user->ID );
            wp_set_auth_cookie( $user->ID);

                        //login

                        $data = [
                            'user_id'       => $user->ID,
                            'status'        => $exists  ? 'login' : 'register',
                            'updated_at'    => current_time('mysql'),
            
                        ];
                        $wpdb->update(
            
                            $wpdb->SIBA_sms_login,
                            $data,
                            [
                                'ID'    => $verify->ID
                            ]
                        );

            $result['message'] = 'ورود با موفقیت انجام شد.';
            wp_send_json_success( $result, 200 );



}
