<?php

function is_ip_blocked($ip) {
    global $wpdb;
    $table = $wpdb->prefix . 'SIBA_blockedip_sms';

    $blocked_ip = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT ip FROM $table WHERE ip = %s",
            $ip
        )
    );

    return !empty($blocked_ip);
}

//چک کردن اینکه آیپی کاربر با توجه به 3 تلاش اخرش بلاک شود  
function should_block_ip($ip) {
    global $wpdb;
    $table = $wpdb->prefix . 'SIBA_sms_login';

    $last_three_expired_dates = $wpdb->get_col(
        $wpdb->prepare(
            "SELECT expired_at FROM $table WHERE ip = %s ORDER BY expired_at DESC LIMIT 3",
            $ip
        )
    );

    if (count($last_three_expired_dates) < 3) {
        return false; //کمتر از 3 دیتا در جدول را محاسبه کن
    }

    $current_time = current_time('timestamp');
    $last_expired_time = strtotime($last_three_expired_dates[0]);
    $oldest_expired_time = strtotime($last_three_expired_dates[2]);

    // اگه آخرین تاریخ منقضی شده 10 ثانیه بیشتر گذشته
    if ($current_time - $oldest_expired_time > 10) {
        return false; // نیازی به بلاک کردن آیپی نیست
    }

    return $last_expired_time - $oldest_expired_time < $SIBA_login_expire; // اگه اختلاف بین آخرین تاریخ های انقضا کمتر از 60 ثانیه است کد را اجرا کن
}


// اضافه کردن آیپی متجاوز به لیست بلاک شده ها
function block_ip($ip) {
    global $wpdb;
    $table = $wpdb->prefix . 'SIBA_blockedip_sms';

    $wpdb->insert(
        $table,
        array(
            'ip' => $ip,
            'block' => 'به دلیل تلاش بیش از حد بلاک شد',
            'time' => current_time('mysql'),
        )
    );
}