<?php


function smsir_lookUp($username, $mobile, $templateId, $parameters = array()) {
    $url = 'https://api.sms.ir/v1/send/verify';

    if (!is_array($parameters)) {
        return array('success' => false, 'message' => 'پارامترها نادرست هستند');
    }

    $paramArray = array();
    foreach ($parameters as $key => $value) {
        $paramArray[] = array(
            "name"  => $key,
            "value" => $value
        );
    }

    $data = array(
        "mobile"     => $mobile,
        "templateId" => (int)$templateId,
        "parameters" => $paramArray
    );

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($data, JSON_UNESCAPED_UNICODE),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Accept: text/plain',
            'x-api-key: ' . $username
        ),
    ));

    $response = curl_exec($curl);

    $status_res = json_decode($response);
    $status_res = $status_res->status;

    if($status_res) return true;
    else return false;
    
}

