<?php
function SIBA_sms_login() {
    // نتیجه پیش‌فرض
    $result = [
        'message' => 'در حال بررسی اطلاعات...'
    ];

    // بررسی فیلد شماره تلفن
    if( ! isset($_REQUEST['phone']) ) {
        $result['message'] = 'شماره تلفن ارسال نشده است';
        wp_send_json_success($result);
        return;
    }


    // تمیز کردن شماره تلفن
    $phone = sanitize_phone($_REQUEST['phone']);
        
        if(! $phone ){
            $result['message'] = 'شماره تلفن صحیح نیست';
            wp_send_json_error($result, 401);
        }   

    $ip_address = $_SERVER['REMOTE_ADDR'];

    // چک کن ببین آیپی تو جدول بلاک شده ها نباشه
    if (is_ip_blocked($ip_address)) {
        $result['message'] = 'شما قبلاً محدود شدید و مجاز به ورود نیستید! به پشتیبان سایت اطلاع دهدید';
        wp_send_json_error($result, 401); // HTTP 403 Forbidden
    }


    if (should_block_ip($ip_address)) {
        block_ip($ip_address);
        $result['message'] = 'بیش از حد تلاش کردید برای رفع محدودیت به پشتیبان سایت اطلاع دهید';
        wp_send_json_error($result, 401); // HTTP 403 Forbidden
    }

// اگه تاریخ انقضا نگذشته مجاز به ارسال کد نیست
    global $wpdb;
    $existing_entry = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT * FROM {$wpdb->SIBA_sms_login} WHERE phone = %s AND expired_at > %s AND ip = %s ORDER BY created_at DESC",
            $phone,
            current_time('mysql'),
            $_SERVER['REMOTE_ADDR']
        )
    );
  

	
$SIBA_login_expire = get_option('SIBA_login_expire');
$SIBA_operator = get_option('SIBA_operator');
$SIBA_username = get_option('SIBA_username');
$SIBA_password = get_option('SIBA_password');
$SIBA_localnumber = get_option('SIBA_localnumber');
$SIBA_api = get_option('SIBA_api');
$SIBA_pattern = get_option('SIBA_pattern');
$SIBA_var1 = get_option('SIBA_var1');
$SIBA_var2 = get_option('SIBA_var2');
	
            // اطلاعات کاربر
$phone = sanitize_phone($_REQUEST['phone']);
$digit = get_option('nsdigitsquantity');
$expire = $SIBA_login_expire;
$code = SIBA_generate_code($digit);
$expired_at = date('Y-m-d H:i:s', current_time('timestamp') + $expire);
$ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '';
	    if ($existing_entry) {
        // Phone number exists with an unexpired code and the same IP address, do not send a new SMS			
        $error_data = array(
            'message' => 'لطفاً کمی صبر کنید کد قبلی ارسال شده هنوز مهلت دارد',
            'error_code' => 123
        );
        wp_send_json_error($error_data, 401);
    }
$inserted = SIBA_register_code($phone, $code, $expired_at, $ip);
	
switch ($SIBA_operator) {
    case "kavenegar":
        require(SIBA_LOGIN_REQ_RES . 'kavenegar.php');
        break;
    case "national_sms":
        require(SIBA_LOGIN_REQ_RES . 'national-sms.php');
        break;
    case "faraz":
        require(SIBA_LOGIN_REQ_RES . 'faraz.php');
        break;
    case "aladdin":
        require(SIBA_LOGIN_REQ_RES . 'aladdin.php');
        break;
    case "smsir":
        require(SIBA_LOGIN_REQ_RES . 'smsir.php');
        break;
    default:
        break;
}
	

	
}