<?php
defined ('ABSPATH') || exit;


function sanitize_phone( $phone ){

    /**
     * Convert all chars to en digits
     */
    $western    = array('0','1','2','3','4','5','6','7','8','9');
    $persian    = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $arabic     = ['٠',  '١',  '٢', '٣','٤', '٥', '٦','٧','٨','٩' ];
    $phone      = str_replace( $persian, $western, $phone );
    $phone      = str_replace( $arabic, $western, $phone );

    //.9158636712   => 09158636712
    if( strpos( $phone, '.' ) === 0 ){
        $phone = '0' . substr( $phone, 1 );
    }

    //00989185223232 => 9185223232
    if( strpos( $phone, '0098' ) === 0 ){
        $phone = substr( $phone, 4 );
    }
    //0989108210911 => 9108210911
    if( strlen( $phone ) == 13 && strpos( $phone, '098' ) === 0 ){
        $phone = substr( $phone, 3 );
    }
    //+989156040160 => 9156040160
    if( strlen( $phone ) == 13 && strpos( $phone, '+98' ) === 0 ){
        $phone = substr( $phone, 3 );
    }
    //+98 9156040160 => 9156040160
    if( strlen( $phone ) == 14 && strpos( $phone, '+98 ' ) === 0 ){
        $phone = substr( $phone, 4 );
    }
    //989152532120 => 9152532120
    if( strlen( $phone ) == 12 && strpos( $phone, '98' ) === 0 ){
        $phone = substr( $phone, 2 );
    }
    //Prepend 0
    if( strpos( $phone, '0' ) !== 0 ){
        $phone = '0' . $phone;
    }
    /**
     * check for all character was digit
     */
    if( ! ctype_digit( $phone ) ){
        return '';
    }

    if( strlen( $phone ) != 11 ){
        return '';
    }

    return $phone;

}
$digits = get_option('nsdigitsquantity');

function SIBA_generate_code( $digits ){
    $code = '';
    for( $i = 0; $i < $digits; $i++){
            $code.= rand( ! $i ? 1 : 0 , 9);
    }
    return $code;
}

function SIBA_register_code($phone, $code, $expired_at, $ip){
global $wpdb;

    $data = [
        'ip'              => $ip,
        'phone'         => $phone,
        'code'          => $code,
        'expired_at'    => $expired_at,
        'created_at'    => current_time( 'mysql' ),
        'updated_at'    => current_time( 'mysql' ),
    ];

    $inserted = $wpdb->insert(
        $wpdb->SIBA_sms_login,
        $data,
        '%s'

    );
    if( ! $inserted ){
        notificator_send_message('insert error for' .$wpdb->SIBA_sms_login . PHP_EOL . print_r($data, true));
        new WP_Error('error_insertion', 'خطا در ثبت داده');
    }
    return $wpdb->insert_id;
}


function SIBA_get_user_by_phone( $phone ){

    $users = get_users([
        'meta_key'      =>  'phone' , 
        'meta_value'    => $phone
        
        ]);
        return empty( $users ) ? false : $users[0];

}


function SIBA_get_or_make_user( $phone ){

$user = SIBA_get_user_by_phone( $phone );

if(! $user ){
    $phone_last = substr($phone, -4);
    $phone_ = $phone;
    $password   = wp_generate_password( 15 );
    // $role = class_exists('WooCommerce') ? 'customer' : 'subscriber';

    // $role = class_exists('WooCommerce') ? 'customer' : 'subscriber';

    $user_id       = wp_create_user( $phone, $password );
    
        wp_update_user([
            'ID' => $user_id
            ]);
    
    $user_login =  $phone_;
	

if( class_exists( 'WooCommerce' )){
		     update_user_meta($user_id, 'billing_phone', $phone_);
                update_user_meta($user_id, 'shipping_phone', $phone_);
		 }

	
    if(! is_wp_error( $user_id )){

        $user = new WP_User( $user_id );
//این خط مشخص میکند یوزر جدید چه نام کاربری ای داشته باشد
        global $wpdb;
        $wpdb->update($wpdb->users,[
            'user_login'    =>  $phone_,
		]
            ,[
                'ID'        => $user_id

        ]);
	$args = array(
    'display_name' => 'user' . $user_id . '-' . $phone_last,
    'nickname'     => 'user' . $user_id . '-' . $phone_last
  );
        wp_cache_flush();

        update_user_meta( $user_id, 'phone', $phone );
		update_user_meta( $user_id ,'nickname' , $user_login  );
		 

    }else{
        $user = $user_id;
    }

}
return $user;

}


/*
add_action( 'woocommerce_edit_account_form', 'add_phone_to_edit_account_form' );
function add_phone_to_edit_account_form() {
    $user = wp_get_current_user();
    ?>
        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide" style="padding:10px; background-color:#2666cf;color:white; border-radius:10px">
            لطفاً شماره موبایل خود را با دقت وارد نمایید
        <label for="phone" style="color:white;"><?php _e( 'شماره موبایل', 'woocommerce' ); ?></label>
        <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="phone" id="phone" value="<?php echo esc_attr( $user->phone ); ?>" />
    </p>
    <?php
}
*/

add_action( 'woocommerce_save_account_details', 'save_phone_account_details', 12, 1 );
function save_phone_account_details( $user_id ) {
    if( isset( $_POST['phone'] ) )
        update_user_meta( $user_id, 'phone', sanitize_text_field( $_POST['phone'] ) );
}

/////////////change display name

function change_display_name( $user_id ) {
    $display_name = get_option('displaynameSIBA');
    $phone = '';
    $phone = get_user_meta($user_id, 'phone', true);
    $new_display_name = '';
    switch ($display_name) {
          case "1":
              $new_display_name = $phone;
            break;
          case "2":
              $phone_last = substr($phone, -4);
              $new_display_name = 'کاربر'.$phone_last;
            break;
          case "3":
              $new_display_name = 'کاربر'.$user_id;
            break;
          case "4":
            $randomNumber = rand(100000, 999999);
            $new_display_name = 'کاربر'.$randomNumber;
            break;
          default:
            $randomNumber = rand(100000, 999999);
            $new_display_name = 'کاربر'.$randomNumber;
        }
    //$site_title = get_bloginfo( 'name' ); 
    // $new_display_name = 'کاربر ' . $user_id . ' - ' . $customtext; 
    $args = array(
        'ID'            => $user_id,
        'display_name'  => $new_display_name
    );
    wp_update_user( $args );
}
add_action( 'user_register', 'change_display_name' );




// این تابع خطای عدم ورود ایمیل را هنگام آپدیت پروفایل کاربر حذف می‌کند
add_action('user_profile_update_errors', 'SIBA_user_profile_update_errors', 10, 3 );
function SIBA_user_profile_update_errors($errors, $update, $user) {
    $errors->remove('empty_email');
}

// این تابع اعتبارسنجی اجباری بودن ایمیل را در فرم‌های جاوااسکریپت حذف می‌کند
// و متن '(required)' را از برچسب حذف می‌کند
// برای فرم‌های کاربر جدید، پروفایل کاربر و ویرایش کاربر عمل می‌کند
add_action('user_new_form', 'SIBA_user_form_js', 10, 1);
add_action('show_user_profile', 'SIBA_user_form_js', 10, 1);
add_action('edit_user_profile', 'SIBA_user_form_js', 10, 1);
function SIBA_user_form_js($form_type) {
    ?>
    <script type="text/javascript">
        jQuery('#email').closest('tr').removeClass('form-required').find('.description').remove();
        // به صورت پیش‌فرض گزینه ارسال ایمیل کاربر جدید را غیرفعال می‌کند
        <?php if (isset($form_type) && $form_type === 'add-new-user') : ?>
            jQuery('#send_user_notification').prop('checked', false);
        <?php endif; ?>
    </script>
    <?php
}

add_action('woocommerce_thankyou', 'update_downloadable_product_permissions', 10, 1);

function update_downloadable_product_permissions($order_id) {
    // دریافت جزئیات سفارش
    $order = wc_get_order($order_id);
    $user_id = $order->get_user_id(); // دریافت ID کاربر
    $site_url = parse_url(get_site_url(), PHP_URL_HOST); // دریافت فقط نام دامنه

    // بررسی اینکه آیا کاربر ایمیل ندارد
    global $wpdb;
    $table_name = $wpdb->prefix . 'woocommerce_downloadable_product_permissions';
    
    // پیدا کردن رکورد کاربر بر اساس سفارش
    $results = $wpdb->get_results(
        $wpdb->prepare("SELECT * FROM $table_name WHERE order_id = %d", $order_id)
    );

    // دریافت شماره تلفن کاربر از متا
    $user_phone = get_user_meta($user_id, 'phone', true);

    foreach ($results as $row) {
        if (empty($row->user_email)) {
            // به‌روزرسانی user_email
            $new_email = $user_phone . '@' . $site_url;
            $wpdb->update(
                $table_name,
                array('user_email' => $new_email), // داده‌های جدید
                array('order_id' => $order_id) // شرط
            );
        }
    }
}

