<?php
defined('ABSPATH') || exit;
add_action('wp_enqueue_scripts', 'SIBA_sms_login_public_scripts');

function SIBA_sms_login_public_scripts() {
    if (is_user_logged_in()) {
        return;
    }

    // استایل CSS بدون کش
    wp_enqueue_style(
        'SIBA-login-style',
        SIBA_LOGIN_CSS . 'style.css',
        [],
        time() // جلوگیری از کش شدن
    );

    // بارگذاری wp-api-fetch به عنوان وابستگی
    wp_enqueue_script('wp-api-fetch');

    // جاوااسکریپت بدون کش
    wp_enqueue_script(
        'SIBA-login-script',
        SIBA_LOGIN_JS . 'script.js',
        ['jquery', 'wp-api-fetch'],
        time(), // جلوگیری از کش شدن
        true
    );

    // تبدیل رشته به آرایه‌ها
    $locked_pages = get_option('SIBA_login_locked_pages');
    $click_links = get_option('SIBA_login_click_links');

    $locked_pages_array = $locked_pages ? array_map('trim', explode(',', $locked_pages)) : [];
    $click_links_array = $click_links ? array_map('trim', explode(',', $click_links)) : [];

    // انتقال متغیرها به جاوااسکریپت
    wp_localize_script('SIBA-login-script', 'SIBA', [
        'lockedPages' => $locked_pages_array,
        'clickLinks' => $click_links_array,
        'ajax_url' => home_url('/SIBA-login'), // تغییر مسیر به مسیر جدید API
        'site_url' => home_url(),
    ]);
}

