<?php
defined ('ABSPATH') || exit;
function SIBA_sms_login_activation() {
    global $wpdb;

    $table              = $wpdb->SIBA_sms_login;
    $table_collation    = $wpdb->collate;

    $sql = "
    CREATE TABLE `$table` (
        `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
        `user_id` bigint unsigned NOT NULL DEFAULT '0',
        `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
        `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
        `attempts` int unsigned NOT NULL DEFAULT '0',  -- Change: Store attempts instead of message_id
        `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
        `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
        `created_at` datetime NOT NULL,
        `updated_at` datetime NOT NULL,
        `expired_at` datetime NOT NULL,
        PRIMARY KEY (`ID`),
        KEY `user_id` (`user_id`),
        KEY `status` (`status`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=$table_collation
    ";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

function SIBA_blockedip_sms_activation() {
  global $wpdb;

  $table = $wpdb->prefix . 'SIBA_blockedip_sms';
  $table_collation = $wpdb->collate;

  $sql = "
  CREATE TABLE `$table` (
      `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
      `block` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
      `time` datetime NOT NULL,
      PRIMARY KEY (`ip`),
      KEY `time` (`time`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=$table_collation
  ";

  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  dbDelta($sql);
}
