<?php

class Elementor_SIBAlogin_widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'SIBA_login_widget';
	}

	public function get_title() {
		return esc_html__( 'ورود | ثبت نام  سیبا', 'SIBA-login-signup' );
	}

	public function get_icon() {
		return 'eicon-upgrade-crown';
	}

	public function get_categories() {
		return [ 'basic' ];
	}

	public function get_keywords() {
		return [ 'ورود | ثبت نام سیبا', 'SIBA' ];
	}

	public function get_custom_help_url() {
		return 'https://elementorSIBA.ir';
	}

	protected function get_upsale_data() {
		return ['elementorSIBA.ir'];
	}

	public function get_style_depends() {
		wp_enqueue_style('SIBA-login-style', SIBA_LOGIN_CSS . 'style.css');

		return ['SIBA-login-style'];
	}

/* -------------------------------------------------------------------------- */
/*                               widget controls                              */
/* -------------------------------------------------------------------------- */

	protected function register_controls() {

		$this->start_controls_section(
			'SIBA_firstform',
			[
				'label' => esc_html__( 'فرم اول درج شماره', 'SIBA-login-signup' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'SIBA_close_outbox',
			[
				'label' => esc_html__( 'با کلیک خارج از باکس بسته شود؟', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'بله', 'SIBA-login-signup' ),
				'label_off' => esc_html__( 'خیر', 'SIBA-login-signup' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'SIBA_close_outnotice',
			[
				'type' => \Elementor\Controls_Manager::NOTICE,
				'notice_type' => 'warning',
				'dismissible' => false,
				'heading' => esc_html__( 'نکته مهم در مورد بستن', 'SIBA-login-signup' ),
				'content' => esc_html__( 'در صورتی که از گزینه بالا استفاده کردید به المان هایی که درج میکنید z-index:9 بدهید', 'SIBA-login-signup' ),
			]
		);

		$this->add_control(
			'SIBA_close_button',
			[
				'label' => esc_html__( 'نمایش دکمه بستن', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'بله', 'SIBA-login-signup' ),
				'label_off' => esc_html__( 'خیر', 'SIBA-login-signup' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		

		$this->add_control(
			'SIBA_firstform_image',
			[
				'label' => esc_html__( 'تصویر ورود', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				],
		
				
			]
		);

		$this->add_control(
			'SIBA_firstform_title',
			[
				'label' => esc_html__( 'عنوان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'ورود / ثبت نام', 'SIBA-login-signup' ),
				'placeholder' => esc_html__( 'عنوان دلخواه را وارد کنید', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);

		$this->add_control(
			'SIBA_firstform_subtitle',
			[
				'label' => esc_html__( 'زیر عنوان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'در صورت روشن بودن vpn خاموش کنید تا به مشکلی نخورید', 'SIBA-login-signup' ),
				'placeholder' => esc_html__( 'زیر عنوان دلخواه را وارد کنید', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);

		$this->add_control(
			'SIBA_firstform_label',
			[
				'label' => esc_html__( 'لیبل شماره موبایل', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'شماره همراه خود را وارد کنید', 'SIBA-login-signup' ),
				'placeholder' => esc_html__( 'متن ورود شماره موبایل', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);

		$this->add_control(
			'SIBA_firstform_phonnumberimage',
			[
				'label' => esc_html__( 'تصویر کنار فیلد شماره موبایل', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				],
		
				
			]
		);

		$this->add_control(
			'SIBA_firstform_countrycode',
			[
				'label' => esc_html__( 'کد کشور', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '+98', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);

		$this->add_control(
			'SIBA_firstform_placeholder',
			[
				'label' => esc_html__( 'متن پیشفرض شماره', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '0 9 - - - - - - - - -', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);



		$this->add_control(
			'SIBA_firstform_button',
			[
				'label' => esc_html__( 'متن دکمه ارسال کد', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'ارسال کد تایید', 'SIBA-login-signup' ),
				'placeholder' => esc_html__( 'متن ارسال کد', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);

		$this->add_control(
			'SIBA_firstform_icon_load',
			[
				'label' => esc_html__( 'آیکون لود دکمه ارسال', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::ICONS,
					'fa-regular' => [
						'circle',
						'dot-circle',
						'square-full',
					],
				]
		);

		$this->end_controls_section();


		/* -------------------------------------------------------------------------- */
		/*                           second tab form control                          */
		/* -------------------------------------------------------------------------- */

		$this->start_controls_section(
			'SIBA_secondform',
			[
				'label' => esc_html__( 'فرم دوم تایید شماره', 'SIBA-login-signup' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'SIBA_secondform_image',
			[
				'label' => esc_html__( 'تصویر تایید شماره', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				],
		
				
			]
		);

		$this->add_control(
			'SIBA_secondform_title',
			[
				'label' => esc_html__( 'عنوان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'تایید شماره همراه', 'SIBA-login-signup' ),
				'placeholder' => esc_html__( 'عنوان دلخواه را وارد کنید', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);

		$this->add_control(
			'SIBA_secondform_subtitle',
			[
				'label' => esc_html__( 'زیر عنوان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '', 'SIBA-login-signup' ),
				'placeholder' => esc_html__( 'زیر عنوان دلخواه را وارد کنید', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);

		$this->add_control(
			'SIBA_secondform_label',
			[
				'label' => esc_html__( 'لیبل کد تایید', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'کد تایید را وارد کنید', 'SIBA-login-signup' ),
				'placeholder' => esc_html__( 'متن کد تایید', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);


		$this->add_control(
			'SIBA_secondform_button',
			[
				'label' => esc_html__( 'متن تایید کد', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'تایید کد', 'SIBA-login-signup' ),
				'placeholder' => esc_html__( 'متن تایید کد', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);

		$this->add_control(
			'SIBA_secondform_editbutton',
			[
				'label' => esc_html__( 'متن اصلاح شماره موبایل', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'اصلاح شماره', 'SIBA-login-signup' ),
				'placeholder' => esc_html__( 'متن اصلاح شماره', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);


		
		$this->add_control(
			'SIBA_secondform_successtext',
			[
				'label' => esc_html__( 'متن ورود موفقیت آمیز', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'ورود با موفقیت انجام شد ', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);
		$this->add_control(
			'SIBA_secondform_successloadertext',
			[
				'label' => esc_html__( 'متن زیر لودر', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'صفحه مجدداً بارگذاری میشود، ممنون از صبوری شما', 'SIBA-login-signup' ),
				'dynamic' => [
					'active' => true,
				],
		
			]
		);

		$this->add_control(
			'SIBA_secondform_successloader',
			[
				'label' => esc_html__( 'آیکون لود موفقیت امیز', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::ICONS,
					'fa-regular' => [
						'circle',
						'dot-circle',
						'square-full',
					],
				]
		);

		$this->end_controls_section();




		/* -------------------------------------------------------------------------- */
		/*                             style tab of widget                            */
		/* -------------------------------------------------------------------------- */


		
		$this->start_controls_section(
			'SIBA_login_style',
			[
				'label' => esc_html__( 'استایل باکس و بک گراند', 'SIBA-login-signup' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'SIBA_style_form_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .SIBA-main-modal',
			]
		);

		$this->add_responsive_control(
			'SIBA_login_style_width',
			[
				'label' => esc_html__( 'عرض باکس لاگین', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 360,
				],
				'selectors' => [
					'{{WRAPPER}} .SIBA-main-modal.SIBA-elementor' => 'width: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
		$this->add_responsive_control(
			'SIBA_login_style_border_radius',
			[
				'label' => esc_html__( 'گردی گوشه ها', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .SIBA-main-modal.SIBA-elementor' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'main_border_SIBAlogin',
				'selector' => '{{WRAPPER}} .SIBA-main-modal',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'SIBA_login_firstform_style',
			[
				'label' => esc_html__( 'استایل فرم اول', 'SIBA-login-signup' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		


		$this->add_responsive_control(
			'SIBA_firstform_logo_width',
			[
				'label' => esc_html__( 'عرض لوگوی فرم اول', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .SIBA-login-form .SIBA-login-form-logo img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'SIBA_firstform_titlestyles',
			[
				'label' => esc_html__( 'استایل عنوان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'firstform_title_typography',
				'selector' => '{{WRAPPER}} .SIBA-modal-title.first-form',
			]
		);
		$this->add_control(
			'firstform_title_typography_align',
			[
				'label' => esc_html__( 'چیدمان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => esc_html__( 'راست چین', 'SIBA-login-signup' ),
						'icon' => 'eicon-text-align-right',
					],

					'center' => [
						'title' => esc_html__( 'وسط چین', 'SIBA-login-signup' ),
						'icon' => 'eicon-text-align-center',
					],

					'left' => [
						'title' => esc_html__( 'چپ چین', 'SIBA-login-signup' ),
						'icon' => 'eicon-text-align-left',
					],

				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .SIBA-modal-title.first-form' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'firstform_title_color',
			[
				'label' => esc_html__( 'رنگ عنوان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .SIBA-modal-title.first-form' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'firstform_title_margin',
			[
				'label' => esc_html__( 'فاصله از اطراف', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'default' => [
					'top' => 5,
					'right' => 0,
					'bottom' => 5,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .SIBA-modal-title.first-form' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'SIBA_firstform_subtitlestyles',
			[
				'label' => esc_html__( 'استایل زیر عنوان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'firstform_subtitle_typography',
				'selector' => '{{WRAPPER}} .SIBA-subtitle',
			]
		);
		$this->add_control(
			'firstform_subtitle_typography_align',
			[
				'label' => esc_html__( 'چیدمان زیر عنوان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => esc_html__( 'راست چین', 'SIBA-login-signup' ),
						'icon' => 'eicon-text-align-right',
					],

					'center' => [
						'title' => esc_html__( 'وسط چین', 'SIBA-login-signup' ),
						'icon' => 'eicon-text-align-center',
					],
					
					'left' => [
						'title' => esc_html__( 'چپ چین', 'SIBA-login-signup' ),
						'icon' => 'eicon-text-align-left',
					],

				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .SIBA-subtitle' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'firstform_subtitle_color',
			[
				'label' => esc_html__( 'رنگ زیر عنوان', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .SIBA-subtitle' => 'color: {{VALUE}}',
				],
			]
		);



		$this->add_control(
			'SIBA_firstform_labelstyles',
			[
				'label' => esc_html__( 'استایل لیبل فیلد', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'firstform_numberlabel_typography',
				'selector' => '{{WRAPPER}} .SIBA-login-field label',
			]
		);
		$this->add_control(
			'firstform_numberlabel_typography_align',
			[
				'label' => esc_html__( 'چیدمان لیبل شماره', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => esc_html__( 'راست چین', 'SIBA-login-signup' ),
						'icon' => 'eicon-text-align-right',
					],

					'center' => [
						'title' => esc_html__( 'وسط چین', 'SIBA-login-signup' ),
						'icon' => 'eicon-text-align-center',
					],
					
					'left' => [
						'title' => esc_html__( 'چپ چین', 'SIBA-login-signup' ),
						'icon' => 'eicon-text-align-left',
					],

				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .SIBA-login-field label' => 'text-align: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'firstform_label_color',
			[
				'label' => esc_html__( 'رنگ لیبل شماره', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .SIBA-login-field label' => 'color: {{VALUE}}',
				],
			]
		);



		$this->add_control(
			'SIBA_firstform_input',
			[
				'label' => esc_html__( 'استایل ناحیه شماره موبایل', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'SIBA_firstform_backgroundinput',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .SIBA-phone-box',
			]
		);
		$this->add_control(
			'SIBA_firstform_colorinput',
			[
				'label' => esc_html__( 'رنگ متن داخل ناحیه', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .SIBA-phone-box' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'SIBA_firstform_input_borderradius',
			[
				'label' => esc_html__( 'گردی گوشه ها', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .SIBA-phone-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'main_border_SIBA_firstform_input',
				'selector' => '{{WRAPPER}} .SIBA-phone-box',
			]
		);

		$this->add_responsive_control(
			'SIBA_firstform_input_paddinginside',
			[
				'label' => esc_html__( 'انداره داخلی فیلد درونی', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .SIBA-phone-box input[type=text]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);



		$this->add_control(
			'SIBA_firstform_inputfocus',
			[
				'label' => esc_html__( 'استایل ناحیه شماره موبایل در حالت انتخاب', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'SIBA_firstform_backgroundinputfocus',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .SIBA-phone-box input[type=text]:focus',
			]
		);
		$this->add_control(
			'SIBA_firstform_colorinputfocus',
			[
				'label' => esc_html__( 'رنگ متن داخل ناحیه', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .SIBA-phone-box input[type=text]:focus' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'main_border_SIBA_firstform_inputfocus',
				'selector' => '{{WRAPPER}} .SIBA-phone-box input[type=text]:focus',
			]
		);



		$this->add_control(
			'SIBA_firstform_buttonstyle',
			[
				'label' => esc_html__( 'استایل دکمه ارسال', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'SIBA_firstform_backgroundbutton',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}}  .SIBA-main-modal .SIBA-login-form button.SIBA-elementor-send-code',
			]
		);
		$this->add_control(
			'SIBA_firstform_colorbutton',
			[
				'label' => esc_html__( 'رنگ متن دکمه', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .SIBA-login-form .SIBA-elementor-send-code' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'SIBA_firstform_button_borderradius',
			[
				'label' => esc_html__( 'گردی گوشه ها', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .SIBA-login-form .SIBA-elementor-send-code' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'main_border_SIBA_firstform_button',
				'selector' => '{{WRAPPER}} #SIBA-login.SIBA-login-form .SIBA-elementor-send-code',
			]
		);

		$this->add_responsive_control(
			'SIBA_firstform_input_buttonpadding',
			[
				'label' => esc_html__( 'انداره داخلی دکمه', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .SIBA-login-form .SIBA-elementor-send-code' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);



		$this->add_control(
			'SIBA_firstform_svgloaderstyle',
			[
				'label' => esc_html__( 'استایل انیمیشن لودر', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'SIBA_firstform_svgloadersize',
			[
				'label' => esc_html__( 'اندازه لودر', 'SIBA-login-signup' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .SIBA-elementor-send-code svg' => 'width: {{SIZE}}{{UNIT}}!important;',
					'{{WRAPPER}} .SIBA-elementor-send-code svg' => 'width: {{SIZE}}{{UNIT}}!important;'
				],
			]
		);


		$this->end_controls_section();





/* -------------------------------------------------------------------------- */
/*                              style tab part 2                              */
/* -------------------------------------------------------------------------- */
	
$this->start_controls_section(
	'SIBA_login_secondtform_style',
	[
		'label' => esc_html__( 'استایل فرم دوم', 'SIBA-login-signup' ),
		'tab' => \Elementor\Controls_Manager::TAB_STYLE,
	]
);



$this->add_responsive_control(
	'SIBA_secondtform_logo_width',
	[
		'label' => esc_html__( 'عرض لوگوی فرم دوم', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::SLIDER,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'range' => [
			'px' => [
				'min' => 0,
				'max' => 1000,
				'step' => 1,
			],
			'%' => [
				'min' => 0,
				'max' => 100,
			],
		],
		'selectors' => [
			'{{WRAPPER}} .SIBA-login-form-logo-code img' => 'width: {{SIZE}}{{UNIT}};',
		],
	]
);

$this->add_control(
	'SIBA_secondtform_titlestyles',
	[
		'label' => esc_html__( 'استایل عنوان', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' => 'secondtform_title_typography',
		'selector' => '{{WRAPPER}} .SIBA-modal-title.second-form',
	]
);
$this->add_control(
	'secondtform_title_typography_align',
	[
		'label' => esc_html__( 'چیدمان', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::CHOOSE,
		'options' => [
			'right' => [
				'title' => esc_html__( 'راست چین', 'SIBA-login-signup' ),
				'icon' => 'eicon-text-align-right',
			],

			'center' => [
				'title' => esc_html__( 'وسط چین', 'SIBA-login-signup' ),
				'icon' => 'eicon-text-align-center',
			],

			'left' => [
				'title' => esc_html__( 'چپ چین', 'SIBA-login-signup' ),
				'icon' => 'eicon-text-align-left',
			],

		],
		'default' => 'center',
		'toggle' => true,
		'selectors' => [
			'{{WRAPPER}} .SIBA-modal-title.second-form' => 'text-align: {{VALUE}};',
		],
	]
);
$this->add_control(
	'secondtform_title_color',
	[
		'label' => esc_html__( 'رنگ عنوان', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .SIBA-modal-title.second-form' => 'color: {{VALUE}}',
		],
	]
);
$this->add_responsive_control(
	'secondtform_title_margin',
	[
		'label' => esc_html__( 'فاصله از اطراف', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'default' => [
			'top' => 5,
			'right' => 0,
			'bottom' => 5,
			'left' => 0,
			'unit' => 'px',
			'isLinked' => false,
		],
		'selectors' => [
			'{{WRAPPER}} .SIBA-modal-title.second-form' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);

$this->add_control(
	'SIBA_secondtform_subtitlestyles',
	[
		'label' => esc_html__( 'استایل زیر عنوان', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);


$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' => 'secondtform_subtitle_typography',
		'selector' => '{{WRAPPER}} .SIBA-login-subtitle',
	]
);
$this->add_control(
	'secondtform_subtitle_typography_align',
	[
		'label' => esc_html__( 'چیدمان زیر عنوان', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::CHOOSE,
		'options' => [
			'right' => [
				'title' => esc_html__( 'راست چین', 'SIBA-login-signup' ),
				'icon' => 'eicon-text-align-right',
			],

			'center' => [
				'title' => esc_html__( 'وسط چین', 'SIBA-login-signup' ),
				'icon' => 'eicon-text-align-center',
			],
			
			'left' => [
				'title' => esc_html__( 'چپ چین', 'SIBA-login-signup' ),
				'icon' => 'eicon-text-align-left',
			],

		],
		'default' => 'center',
		'toggle' => true,
		'selectors' => [
			'{{WRAPPER}} .SIBA-login-subtitle' => 'text-align: {{VALUE}};',
		],
	]
);
$this->add_control(
	'secondtform_subtitle_color',
	[
		'label' => esc_html__( 'رنگ زیر عنوان', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .SIBA-login-subtitle' => 'color: {{VALUE}}',
		],
	]
);



$this->add_control(
	'SIBA_secondtform_labelstyles',
	[
		'label' => esc_html__( 'استایل لیبل فیلد', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);


$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' => 'secondtform_numberlabel_typography',
		'selector' => '{{WRAPPER}} .SIBA-login-result',
	]
);
$this->add_control(
	'secondtform_numberlabel_typography_align',
	[
		'label' => esc_html__( 'چیدمان لیبل کد', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::CHOOSE,
		'options' => [
			'right' => [
				'title' => esc_html__( 'راست چین', 'SIBA-login-signup' ),
				'icon' => 'eicon-text-align-right',
			],

			'center' => [
				'title' => esc_html__( 'وسط چین', 'SIBA-login-signup' ),
				'icon' => 'eicon-text-align-center',
			],
			
			'left' => [
				'title' => esc_html__( 'چپ چین', 'SIBA-login-signup' ),
				'icon' => 'eicon-text-align-left',
			],

		],
		'default' => 'center',
		'toggle' => true,
		'selectors' => [
			'{{WRAPPER}} .SIBA-login-result' => 'text-align: {{VALUE}}!important;',
		],
	]
);
$this->add_control(
	'secondtform_label_color',
	[
		'label' => esc_html__( 'رنگ لیبل کد', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .SIBA-login-result' => 'color: {{VALUE}}',
		],
	]
);



$this->add_control(
	'SIBA_secondtform_input',
	[
		'label' => esc_html__( 'استایل ناحیه کد تایید', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	[
		'name' => 'SIBA_secondtform_backgroundinput',
		'types' => [ 'classic', 'gradient', 'video' ],
		'selector' => '{{WRAPPER}} .SIBA-code-box input[type=tel]',
	]
);
$this->add_control(
	'SIBA_secondtform_colorinput',
	[
		'label' => esc_html__( 'رنگ متن داخل ناحیه', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .SIBA-code-box input[type=tel]' => 'color: {{VALUE}}',
		],
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_input_borderradius',
	[
		'label' => esc_html__( 'گردی گوشه ها', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'default' => [
			'top' => 10,
			'right' => 10,
			'bottom' => 10,
			'left' => 10,
			'unit' => 'px',
			'isLinked' => true,
		],
		'selectors' => [
			'{{WRAPPER}} .SIBA-code-box input[type=tel]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Border::get_type(),
	[
		'name' => 'main_border_SIBA_secondtform_input',
		'selector' => '{{WRAPPER}} .SIBA-code-box input[type=tel]',
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_input_paddinginside',
	[
		'label' => esc_html__( 'انداره داخلی فیلد', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'selectors' => [
			'{{WRAPPER}} .SIBA-code-box input[type=tel]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);


$this->add_control(
	'SIBA_secondtform_inputfocus',
	[
		'label' => esc_html__( 'استایل ناحیه کد تایید در حالت انتخاب', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	[
		'name' => 'SIBA_secondtform_backgroundinputfocus',
		'types' => [ 'classic', 'gradient', 'video' ],
		'selector' => '{{WRAPPER}} .SIBA-code-box input[type=tel]:focus',
	]
);
$this->add_control(
	'SIBA_secondtform_colorinputfocus',
	[
		'label' => esc_html__( 'رنگ متن داخل ناحیه', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .SIBA-code-box input[type=tel]:focus' => 'color: {{VALUE}}',
		],
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_inputfocus_borderradius',
	[
		'label' => esc_html__( 'گردی گوشه ها', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'default' => [
			'top' => 10,
			'right' => 10,
			'bottom' => 10,
			'left' => 10,
			'unit' => 'px',
			'isLinked' => true,
		],
		'selectors' => [
			'{{WRAPPER}} .SIBA-code-box input[type=tel]:focus' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Border::get_type(),
	[
		'name' => 'main_border_SIBA_secondtform_inputfocus',
		'selector' => '{{WRAPPER}} .SIBA-code-box input[type=tel]:focus',
	]
);


$this->add_control(
	'SIBA_secondtform_buttonstyle',
	[
		'label' => esc_html__( 'استایل دکمه تایید', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);


$this->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	[
		'name' => 'SIBA_secondtform_backgroundbutton',
		'types' => [ 'classic', 'gradient', 'video' ],
		'selector' => '{{WRAPPER}}  .SIBA-main-modal .SIBA-confirm-box button.SIBA-confirm-code',
	]
);
$this->add_control(
	'SIBA_secondtform_colorbutton',
	[
		'label' => esc_html__( 'رنگ متن دکمه', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .SIBA-main-modal .SIBA-confirm-box button.SIBA-confirm-code' => 'color: {{VALUE}}',
		],
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_button_borderradius',
	[
		'label' => esc_html__( 'گردی گوشه ها', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'default' => [
			'top' => 10,
			'right' => 10,
			'bottom' => 10,
			'left' => 10,
			'unit' => 'px',
			'isLinked' => true,
		],
		'selectors' => [
			'{{WRAPPER}} .SIBA-main-modal .SIBA-confirm-box button.SIBA-confirm-code' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Border::get_type(),
	[
		'name' => 'main_border_SIBA_secondtform_button',
		'selector' => '{{WRAPPER}} .SIBA-main-modal .SIBA-confirm-box button.SIBA-confirm-code',
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_input_buttonpadding',
	[
		'label' => esc_html__( 'انداره داخلی دکمه', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'selectors' => [
			'{{WRAPPER}} .SIBA-main-modal .SIBA-confirm-box button.SIBA-confirm-code' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);


$this->add_control(
	'SIBA_secondtform_buttoneditnumber',
	[
		'label' => esc_html__( 'استایل دکمه اصلاح شماره', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	[
		'name' => 'SIBA_secondtform_buttoneditnumberback',
		'types' => [ 'classic', 'gradient', 'video' ],
		'selector' => '{{WRAPPER}}  .SIBA-main-modal #SIBA-change-number',
	]
);

$this->add_control(
	'SIBA_secondtform_colorbuttoneditnumber',
	[
		'label' => esc_html__( 'رنگ متن دکمه', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .SIBA-main-modal #SIBA-change-number' => 'color: {{VALUE}}',
		],
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_buttoneditnumber_borderradius',
	[
		'label' => esc_html__( 'گردی گوشه ها', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'default' => [
			'top' => 10,
			'right' => 10,
			'bottom' => 10,
			'left' => 10,
			'unit' => 'px',
			'isLinked' => true,
		],
		'selectors' => [
			'{{WRAPPER}} .SIBA-main-modal #SIBA-change-number' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Border::get_type(),
	[
		'name' => 'main_border_SIBA_secondtform_buttoneditnumber',
		'selector' => '{{WRAPPER}} .SIBA-main-modal #SIBA-change-number',
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_input_buttoneditnumberpadding',
	[
		'label' => esc_html__( 'انداره داخلی دکمه', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'selectors' => [
			'{{WRAPPER}} .SIBA-main-modal #SIBA-change-number' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);


$this->add_control(
	'SIBA_secondtform_resend',
	[
		'label' => esc_html__( 'استایل باکس ارسال مجدد', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	[
		'name' => 'SIBA_secondtform_resendback',
		'types' => [ 'classic', 'gradient', 'video' ],
		'selector' => '{{WRAPPER}}  .SIBA-main-modal .SIBA-resendbox',
	]
);

$this->add_control(
	'SIBA_secondtform_colorbuttoneresend',
	[
		'label' => esc_html__( 'رنگ متن باکس', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .SIBA-main-modal .SIBA-resendbox' => 'color: {{VALUE}}',
		],
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_resend_borderradius',
	[
		'label' => esc_html__( 'گردی گوشه ها', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'default' => [
			'top' => 10,
			'right' => 10,
			'bottom' => 10,
			'left' => 10,
			'unit' => 'px',
			'isLinked' => true,
		],
		'selectors' => [
			'{{WRAPPER}} .SIBA-main-modal .SIBA-resendbox' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Border::get_type(),
	[
		'name' => 'main_border_SIBA_secondtform_resend',
		'selector' => '{{WRAPPER}} .SIBA-main-modal .SIBA-resendbox',
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_input_resendpadding',
	[
		'label' => esc_html__( 'انداره داخلی باکس', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'selectors' => [
			'{{WRAPPER}} .SIBA-main-modal .SIBA-resendbox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);



$this->add_control(
	'SIBA_secondtform_resendactive',
	[
		'label' => esc_html__( 'استایل دکمه فعال ارسال مجدد', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	[
		'name' => 'SIBA_secondtform_resendbackactive',
		'types' => [ 'classic', 'gradient', 'video' ],
		'selector' => '{{WRAPPER}}  .SIBA-resend.active',
	]
);

$this->add_control(
	'SIBA_secondtform_colorbuttoneresendactive',
	[
		'label' => esc_html__( 'رنگ متن باکس', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .SIBA-resend.active' => 'color: {{VALUE}}',
		],
	]
);




$this->add_control(
	'SIBA_secondtform_svgloaderstyle',
	[
		'label' => esc_html__( 'استایل انیمیشن لودر تایید', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::HEADING,
		'separator' => 'before',
	]
);

$this->add_responsive_control(
	'SIBA_secondtform_svgloadersize',
	[
		'label' => esc_html__( 'اندازه لودر', 'SIBA-login-signup' ),
		'type' => \Elementor\Controls_Manager::SLIDER,
		'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		'range' => [
			'px' => [
				'min' => 0,
				'max' => 1000,
				'step' => 1,
			],
			'%' => [
				'min' => 0,
				'max' => 100,
			],
		],
		'selectors' => [
			'{{WRAPPER}} .SIBA-confirm-code svg' => 'width: {{SIZE}}{{UNIT}}!important;',
			'{{WRAPPER}} .SIBA-confirm-code svg' => 'width: {{SIZE}}{{UNIT}}!important;'
		],
	]
);


$this->end_controls_section();




















	}


















/* -------------------------------------------------------------------------- */
/*                           widget render html code                          */
/* -------------------------------------------------------------------------- */

	protected function render() {
		$settings = $this->get_settings_for_display();
		



		$digits = get_option('nsdigitsquantity');
				?>
		<style>
			.SIBA-modal-box{
				background-color: transparent;
				backdrop-filter: none;
				-webkit-backdrop-filter: none;
			}
		.SIBA-modal-box [data-elementor-post-type="elementor_library"] {
			width: 100%;
				height: 100%;
			}
			.SIBA-close-modal.container{
				position: fixed;
				height: 100vh;
				width: 100vw;
				top: 0;
				right: 0;
				display: block;
				z-index:-9;
}
			.elementor-editor-active .SIBA-main-modal ,.elementor-editor-active .SIBA-modal-box ,.elementor-editor-active .SIBA-login-code{
				display: block!important;
				width: auto!important;
				height: auto!important;
			}
			.elementor-editor-active .notif-in-editor-SIBA{
				display: block!important;
				text-align: center;
				background-color: red;
				color: white;
			}
			
		</style>
		<?php
				if ( 'yes' === $settings['SIBA_close_outbox'] ) {
					?>
			<div class="SIBA-close-modal container"></div>
			<?php
		}
		?>
		
			<div class="SIBA-main-modal SIBA-elementor" style="z-index:999999">
	

			<?php
				if ( 'yes' === $settings['SIBA_close_button'] ) {
					?>
				<button class="SIBA-close-modal" type="button">
					<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
						<path d="M12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22Z" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
						<path d="M9.16998 14.83L14.83 9.17004" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
						<path d="M14.83 14.83L9.16998 9.17004" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
						</svg>
						بستن
				</button>			<?php
		}
		?>

				<div>
			<form class="SIBA-login-form" id="SIBA-login">
			<?php
// Check if the URL contains 'action=elementor'
if (isset($_GET['action']) && $_GET['action'] === 'elementor') {
?>

<?php

}
?>
				<div class="SIBA-login-form-logo">
				<?php 
				echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'SIBA_firstform_image');
				?>
				</div>
				<span class="SIBA-modal-title first-form" > <?php echo esc_html( $settings['SIBA_firstform_title'] ); ?>  </span>
				<p class="SIBA-subtitle" style="margin: 0;"><?php echo esc_html( $settings['SIBA_firstform_subtitle'] ); ?></p>
				<div class="SIBA-login-field">
				<label for="SIBAphoneinput"><?php echo esc_html( $settings['SIBA_firstform_label'] ); ?></label>
				<div class="SIBA-phone-box">
					<svg class="SIBA-checkicon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
						<path opacity="0.4" d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" fill="#00C72C"/>
						<path d="M10.5795 15.5801C10.3795 15.5801 10.1895 15.5001 10.0495 15.3601L7.21945 12.5301C6.92945 12.2401 6.92945 11.7601 7.21945 11.4701C7.50945 11.1801 7.98945 11.1801 8.27945 11.4701L10.5795 13.7701L15.7195 8.6301C16.0095 8.3401 16.4895 8.3401 16.7795 8.6301C17.0695 8.9201 17.0695 9.4001 16.7795 9.6901L11.1095 15.3601C10.9695 15.5001 10.7795 15.5801 10.5795 15.5801Z" fill="#00C72C"/>
						</svg>
					<input id="SIBAphoneinput" maxlength="11" type="text" inputmode="tel" placeholder="
					<?php echo esc_html( $settings['SIBA_firstform_placeholder'] ); ?>
					" name="phone" required>
					<span>
						<?php echo esc_html( $settings['SIBA_firstform_countrycode'] ); ?>
					</span>
				<?php 
				echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'SIBA_firstform_phonnumberimage');
				?>
				</div>
				<span class="SIBA-login-message">
			</span>			
				<input type="hidden" name="action" value="SIBA_login">
				<?php wp_nonce_field('SIBA-login');?>
				<button class="SIBA-elementor-send-code">
					<div class="elementor-icon">
				<?php \Elementor\Icons_Manager::render_icon( $settings['SIBA_firstform_icon_load'], [ 'aria-hidden' => 'true' ] ); ?>
				</div>
					<?php echo esc_html( $settings['SIBA_firstform_button'] ); ?>				</button>
					</div>
			</form>
		
		
			<form class="SIBA-login-code" id="SIBA-code-form">
				<div class="SIBA-login-form-logo-code">
				<?php 
				echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'SIBA_secondform_image');
				?>
				</div>
				<span class="SIBA-modal-title second-form" ><?php echo esc_html( $settings['SIBA_secondform_title'] ); ?></span>
				<p class="SIBA-login-subtitle"><?php echo esc_html( $settings['SIBA_secondform_subtitle'] ); ?></p>

				<p class="SIBA-login-result"><?php echo esc_html( $settings['SIBA_secondform_label'] ); ?></p>
				<div class="SIBA-login-field">
				<div class="SIBA-code-box">
		
				<?php foreach( range( 1, $digits) as $index): ?>
					<input type="tel" inputmode="tel" pattern="[0-9]*" maxlength="1" autocomplete="off" >
				<?php endforeach;?>
		
				</div>
			<div class="SIBA-under-code">
				<div class="SIBA-resendbox">
					<a class="SIBA-resend" href="#">ارسال مجدد</a>
					<span class="SIBA-countdown">01:48</span>
				</div>
			</div>
			<span class="SIBA-login-message">
		</span>
		<div class="SIBA-success" style="display: none;"> 
		<p class="SIBAlogin-success-title"><?php echo esc_html( $settings['SIBA_secondform_successtext'] ); ?></p>
		<p class="SIBAlogin-success-subtitle">					
			<div class="elementor-icon">
			<?php \Elementor\Icons_Manager::render_icon( $settings['SIBA_secondform_successloader'], [ 'aria-hidden' => 'true' ] ); ?>
			</div>
		<?php echo esc_html( $settings['SIBA_secondform_successloadertext'] ); ?></p>
		</div>
			<div class="SIBA-confirm-box">
				<button class="SIBA-confirm-code">
					<input type="hidden" name="code" id="SIBA-verify-code" value="">
					<input type="hidden" name="phone" value="">
					<input type="hidden" name="_wpnonce" value="">
					<input type="hidden" name="action" value="SIBA_verify">
					<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><style>.spinner_d9Sa{transform-origin:center}.spinner_qQQY{animation:spinner_ZpfF 9s linear infinite}.spinner_pote{animation:spinner_ZpfF .75s linear infinite}@keyframes spinner_ZpfF{100%{transform:rotate(360deg)}}</style><path d="M12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,20a9,9,0,1,1,9-9A9,9,0,0,1,12,21Z"/><rect class="spinner_d9Sa spinner_qQQY" x="11" y="6" rx="1" width="2" height="7"/><rect class="spinner_d9Sa spinner_pote" x="11" y="11" rx="1" width="2" height="9"/></svg>
					<?php echo esc_html( $settings['SIBA_secondform_button'] ); ?>
				</button>
				<button type="button" class="SIBA-change-phone" id="SIBA-change-number">
				<?php echo esc_html( $settings['SIBA_secondform_editbutton'] ); ?>
				</button>
			</div>
			</div>
			</form>
			</div>
			</div>
		<?php

		
	}


}
