jQuery(document).ready(function($) {

  var countdown = 1000;

  function countdown_handle(){
 

          if( countdown == 0 ){
              $('.SIBA-resendbox').addClass('active');
              $('.SIBA-resend').addClass('active');
			  $('.SIBA-login-message')
                  .removeClass('SIBA-countdown')
                  .text('مدت زمان کد قبلی به پایان رسید لطفاً مجدد تلاش کنید')
                  .css('display', 'block');

          }

          countdown--;
          
          set_time(countdown);

  }


  setInterval( countdown_handle, 1000);

  function set_time( countdown ){

      let remain  = countdown >=0 ? countdown : 0;
      let minute  = Math.floor( remain / 60 );
      minute = minute < 10 ? '0' + minute : minute;

      let second  = remain % 60;
      second = second < 10 ? '0' + second : second;

      let time    = `${minute}:${second}`;

      $('.SIBA-countdown').text( time );

  }

  $(document).on('focus','.SIBA-code-box input ', function(e){
      $(this).select();
  });
  $(document).on('input','.SIBA-code-box input ', function(e){
  let code = $(this).val().trim();
  if( code.length ){
      if( $(this).next()){
          $(this).next().focus();
      }
      if( $(this).index() >= $('.SIBA-code-box input').length - 1){
          $('#SIBA-code-form').submit();
      }
  }
  });

  $('#SIBA-change-number').click(toggle_form);
  
  function toggle_form(){
      $('.SIBA-main-modal').toggleClass('verify');
  }

  function close_modal(){
      $('.SIBA-modal-box').removeClass('open');
  }

  function open_modal(e){
      //جلوگیری از باز شدن لینک دیفالت
      e.preventDefault();
      $('.SIBA-modal-box').addClass('open');
  }


  $('.SIBA-close-modal').click(close_modal);


$('#SIBA-login').submit(function(e) {
    e.preventDefault();

    data = $(this).serialize();
    _this = $(this);
    _message = $(this).find('.SIBA-login-message');
    _btn = $(this).find('button');
    _resend = $('.SIBA-resend');

   $.ajax({
        type: 'POST',
        url: SIBA.site_url + '/SIBA-login', // استفاده از endpoint جدید
        data: data,
        beforeSend: function() {
            _this.addClass('loading');
            _message.removeClass('active');
            _btn.attr('disabled', true);
            _resend.text('درحال ارسال...').removeClass('active');
        },
        success: function(result) {
            if (result.success) {
                countdown = result.data.duration;
                set_time(countdown);
                $(".SIBA-login-result").text(result.data.message);
                $('.SIBA-main-modal').addClass('verify');
                $(".SIBA-code-box input").eq(0).focus();

                $("#SIBA-code-form input[name='phone']").val(result.data.phone);
                $("#SIBA-code-form input[name='_wpnonce']").val(result.data._wpnonce);
            } else {

      }
  },
complete: function () {
    _this.removeClass('loading');
    _btn.attr('disabled', false);
    _resend.text('ارسال مجدد');
},
error: function (xhr) {
    let result = xhr.responseJSON;


    if (xhr.status === 400) {
        // مدیریت خطای 400 Bad Request
        _message.addClass('active').text('شما قبلاً وارد شده‌اید، صفحه رفرش می‌شود...');
        location.reload(true); // بارگذاری مجدد صفحه بدون کش
    } else if (xhr.responseText && xhr.responseText.includes('Denied')) {
        _message.addClass('active').text('لطفاً فیلترشکن را خاموش کنید');
    } else if (result && result.data && result.data.message) {
        _message.addClass('active').text(result.data.message);
    } else {
        _message.addClass('active').text(result.data.message);
    }
  },
});
});


$(document).on('click', '.SIBA-resend.active' , function(e){
  e.preventDefault();
  if( countdown <= 0){
      $('#SIBA-login').submit();
  }
});









$(document).on('submit', '#SIBA-code-form', function(e){

  e.preventDefault();


let code            = '';
$(this).find('.SIBA-code-box input').each(function(){
  code+= $(this).val();
});
$("#SIBA-code-form input[name='code']").val( code );

let data            = $(this).serialize();
let _this           = $(this);
let _message        = $(this).find('.SIBA-login-message');
let _message_s        = $(this).find('.SIBA-success');
let _btn            = $(this).find('button');

$.ajax({
    type: 'POST',
    url: SIBA.site_url + '/SIBA-verify', // استفاده از URL تعریف‌شده در Rewrite API
    data: data,
beforeSend: function(){
  $(_this).addClass('loading');
  $(_btn).attr('disabled' , true);
},
success : function( result ){
if(result.success){
  $(_message_s).show();
  location.reload();

}else{

}

},
complete : function(){
  $(_this).removeClass('loading');
  $(_btn).attr('disabled' , false);
},
error       :function( xhr ){
  if (typeof navigator.vibrate === 'function') {
    navigator.vibrate(200);
  }
let result = xhr.responseJSON;
$(_message).addClass('active').text( result.data.message );
document.querySelectorAll('.SIBA-code-box input').forEach(input => {
  input.style.border = '1px solid rgb(255, 77, 84)';
});
},











});

});


function process_otp( otp ){

  let code = otp.code;

  let code_array = code.split('');


  for( let i = 0; i < code_array.length; i++ ){
      $('.SIBA-code-box input').eq(i).val(code_array[i]);
  }

  $('#SIBA-verify-code').val( code );

$('#SIBA-code-form').submit();

}

//process_otp({code: '63253'});

// Feature detection
if ('OTPCredential' in window) {

  const ac = new AbortController();
  $('#SIBA-code-form').submit(function(e){
ac.abort();

  });

  navigator.credentials.get({
      otp: { transport:['sms'] },
      signal: ac.signal
    }).then( process_otp);

  }

  $(document).ready(function() {
    // پردازش صفحات قفل شده
    var lockedPages = SIBA.lockedPages;
    lockedPages.forEach(function(page) {
        if (window.location.href.indexOf(page) > -1) {
            $('.SIBA-modal-box').addClass('open');
            $('body > *').not('.SIBA-modal-box, script , link').remove();
            $('.SIBA-close-modal').remove();
        }
    });

    // پردازش لینک‌های کلیک
    var clickLinks = SIBA.clickLinks;
    clickLinks.forEach(function(link) {
        $(document).on('click', "a[href*='" + link + "']", open_modal);
    });
});
  



//شرط گذاری اصلاح شماره موبایل در فرم اول
$(document).ready(function() {
  // Attach input event listener to the input field
  $('#SIBAphoneinput').on('input', function() {
    // Get the input value
    var inputValue = $(this).val();

    // Check if the input has at least 3 characters
    if (inputValue.length >= 3) {
      // Check if the input starts with "09"
      if (inputValue.startsWith("09")) {
        // Do nothing
      }
      // Check if the input starts with "9"
      else if (inputValue.startsWith("9")) {
        // Add "0" before the input value
        $(this).val("0" + inputValue);
      }
      // If the input doesn't start with "09" or "9"
      else {
        // Add "09" at the beginning of the input value
        $(this).val("09" + inputValue);
      }
    }
  });
});

$(document).ready(function() {
  // Attach input event listener to the input field
  $('#SIBAphoneinput').on('input', function() {
    // Get the input value
    var inputValue = $(this).val();

    // Check if the input has 11 letters
    if (inputValue.length === 11) {
      // Add the "correct" class to the ".SIBA-checkicon" element
      $('.SIBA-checkicon').addClass('correct');
    } else {
      // Remove the "correct" class from the ".SIBA-checkicon" element
      $('.SIBA-checkicon').removeClass('correct');
    }
  });
});


$(document).on('keydown', '.SIBA-code-box input', function(e){
  if (e.key === 'Backspace' && $(this).val().trim() === '') {
      // اگر کاربر روی backspace کلیک کرده و input خالی است
      // پیدا کردن ورودی قبلی و پاک کردن محتوای آن
      let prevInput = $(this).prev();
      if (prevInput.length) {
          prevInput.val('').focus();
      }
  }
});
});


//wp-api-fetch
document.addEventListener('DOMContentLoaded', function() {
    if (typeof wp !== 'undefined' && wp.apiFetch) {
        var rootURLMiddleware = wp.apiFetch.createRootURLMiddleware(SIBA.site_url + "/wp-json/");
        wp.apiFetch.use(rootURLMiddleware);
    } else {
        console.error('wp.apiFetch is not defined');
    }
});





document.querySelectorAll('.SIBA-code-box input').forEach(input => {
  input.addEventListener('input', function() {
    this.style.border = '';
  });
});


