<?php

function SIBA_user_inputs($user) {
    $phone = '';
    
    // بررسی و گرفتن مقدار متای کاربر
    if (is_a($user, 'WP_User')) {
        $phone = get_user_meta($user->ID, 'phone', true);
    }

    // درج فرم از فایل
    include SIBA_LOGIN_VIEW . 'user-inputs.php';
}

// بروزرسانی اطلاعات کاربر هنگام ویرایش پروفایل
add_action('edit_user_profile_update', 'SIBA_update_user');
add_action('personal_options_update', 'SIBA_update_user');

// ذخیره اطلاعات کاربر هنگام ایجاد کاربر جدید
add_action('user_register', 'SIBA_update_user');

function SIBA_update_user($user_id) {
    if (!current_user_can('edit_user', $user_id)) {
        return;
    }

    if (isset($_POST['SIBA_phone'])) {
        $phone = sanitize_text_field($_POST['SIBA_phone']);
        update_user_meta($user_id, 'phone', $phone);
    }
}


add_filter( 'manage_users_columns', 'SIBA_users_columns' );
function SIBA_users_columns( $cols ){
    $cols['phone'] = 'تلفن';
    return $cols;
}

add_filter( 'manage_users_custom_column', 'SIBA_users_columns_data', 10,3 );
function SIBA_users_columns_data( $output , $column_name , $user_id ){

    if( $column_name == 'phone' ){
        $output = get_user_meta( $user_id, 'phone' , true );
        if( !$output ){
            $output = '-';
        }
    }
    return $output;
}


//ایجاد ترتیب برای شماره و سرچ بر اساس شماره در قسمت کاربران

// Enable sorting for the custom column
add_filter( 'manage_users_sortable_columns', 'SIBA_users_sortable_columns' );
function SIBA_users_sortable_columns( $columns ) {
    $columns['phone'] = 'phone';
    return $columns;
}




//Searching Meta Data in Admin
add_action('pre_user_query','yoursite_pre_user_search');
function yoursite_pre_user_search($user_search) {
    global $wpdb;
    if (!isset($_GET['s'])) return;

    //Enter Your Meta Fields To Query
    $search_array = array("customer_id", "postal_code", "churchorganization_name", "first_name", "last_name" , "phone");

    $user_search->query_from .= " INNER JOIN {$wpdb->usermeta} ON {$wpdb->users}.ID={$wpdb->usermeta}.user_id AND (";
    for($i=0;$i<count($search_array);$i++) {
        if ($i > 0) $user_search->query_from .= " OR ";
            $user_search->query_from .= "{$wpdb->usermeta}.meta_key='" . $search_array[$i] . "'";
        }
    $user_search->query_from .= ")";        
    $custom_where = $wpdb->prepare("{$wpdb->usermeta}.meta_value LIKE '%s'", "%" . $_GET['s'] . "%");
    $user_search->query_where = str_replace('WHERE 1=1 AND (', "WHERE 1=1 AND ({$custom_where} OR ",$user_search->query_where);    
}
