<?php
/**
 * SIBA login signup
 *
 * @package           PluginPackage
 * @author            SIBA
 * @copyright         2024 SIBA
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
* Plugin Name:       SIBA login signup | افزونه ورود و ثبت نام سیبا
 * Plugin URI:        https://sibasoft.ir
 * Description:        این پلاگین توسط <a href="https://sibasoft.ir"> سیبا سافت </a> طراحی و توسعه داده شده است | ورود و ثبت نام سریع با افزونه سیبا
 * Version:           1.0.1
 * Requires at least: 5.2
 * Requires PHP:      7.4
 * Author:            SIBA
 * Author URI:        https://sibasoft.ir
 * Text Domain:       SIBA-login-signup
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */
defined ('ABSPATH') || exit;

define('SIBA_LOGIN_VERSION' , '1.2.4');

define('SIBA_LOGIN_URL', plugin_dir_url(__FILE__));
define('SIBA_LOGIN_CSS', SIBA_LOGIN_URL . 'assets/css/');
define('SIBA_LOGIN_JS', SIBA_LOGIN_URL . 'assets/js/');
define('SIBA_LOGIN_IMAGES', SIBA_LOGIN_URL . 'assets/images/');

define('SIBA_LOGIN_PUBLIC' , plugin_dir_path( __FILE__ ) . 'public/');
define('SIBA_LOGIN_VIEW' , plugin_dir_path( __FILE__ ) . 'view/');
define('SIBA_LOGIN_INC' , plugin_dir_path( __FILE__ ) . 'inc/');
define('SIBA_LOGIN_REQUEST' , plugin_dir_path( __FILE__ ) . 'inc/request/');
define('SIBA_LOGIN_REQ_RES' , plugin_dir_path( __FILE__ ) . 'inc/request/res/');
define('SIBA_LOGIN_REQ_SEND' , plugin_dir_path( __FILE__ ) . 'inc/request/send/');
define('SIBA_LOGIN_ADMIN' , plugin_dir_path( __FILE__ ) . 'admin/');
define('SIBA_LOGIN_ADMIN_SETTINGS' , plugin_dir_path( __FILE__ ) . 'admin/settings/');
define('SIBA_LOGIN_TEMPLATE' , plugin_dir_path( __FILE__ ) . 'shortcodes-template/');
define('SIBA_ELEMENTOR_WIDGET' , plugin_dir_path( __FILE__ ) . 'elementor-widget/');


global $wpdb;
$wpdb->SIBA_sms_login = $wpdb->prefix . 'SIBA_sms_login';
$wpdb->SIBA_blockedip_sms = $wpdb->prefix . 'SIBA_blockedip_sms';


require(SIBA_ELEMENTOR_WIDGET . 'modal-widget.php');
require(SIBA_LOGIN_TEMPLATE . 'simple.php');
require(SIBA_LOGIN_INC . 'enqueue.php');
require(SIBA_LOGIN_INC . 'functions.php');
require(SIBA_LOGIN_INC . 'activation.php');
require(SIBA_LOGIN_INC . 'ajax.php');
require(SIBA_LOGIN_PUBLIC . 'modal.php');
if(is_admin()){
    require(SIBA_LOGIN_ADMIN . 'manage-users.php');
}


register_activation_hook( __FILE__, 'SIBA_sms_login_activation' );
register_activation_hook( __FILE__, 'SIBA_blockedip_sms_activation' );

// Schedule a daily cron job
//این کرون جدول مربوط به پلاگین را بصورت ساعتی پاکسازی میکند
//میتوانید , daily, hourly را به weekly تغییر دهید
if (!wp_next_scheduled('SIBA_login_plugin_event')) {
 wp_schedule_event(time(), 'daily', 'SIBA_login_plugin_event');

}

function cs_logout_redirect() {
	wp_redirect( home_url() );
	exit;
}
add_action( 'wp_logout', 'cs_logout_redirect' );



function SIBA_login_plugin_function() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'SIBA_sms_login';

    // Cleanup query for the 'SIBA_sms_login' table
    $wpdb->query("DELETE FROM $table_name;");
}

// Add cleanup function to the daily cron job
add_action('SIBA_login_plugin_event', 'SIBA_login_plugin_function');




function SIBA_flush_rewrite_rules() {
    flush_rewrite_rules();
}

// اجرا هنگام فعال‌سازی پلاگین
register_activation_hook(__FILE__, 'SIBA_flush_rewrite_rules');

// اجرا هنگام بروزرسانی پلاگین
add_action('upgrader_process_complete', 'SIBA_flush_rewrite_rules_on_update', 10, 2);
function SIBA_flush_rewrite_rules_on_update($upgrader_object, $options) {
    if ($options['action'] == 'update' && $options['type'] == 'plugin') {
        $plugin_basename = plugin_basename(__FILE__);
        if (isset($options['plugins']) && in_array($plugin_basename, $options['plugins'])) {
            SIBA_flush_rewrite_rules();
        }
    }
}

// اجرا هنگام غیرفعال‌سازی پلاگین
register_deactivation_hook(__FILE__, 'SIBA_flush_rewrite_rules');

// اجرا هنگام حذف پلاگین
register_uninstall_hook(__FILE__, 'SIBA_flush_rewrite_rules');


// تنظیمات و دکمه فلش کردن در منوی پلاگین‌ها
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'SIBA_add_settings_link');
function SIBA_add_settings_link($links) {
    $flush_link = '<a href="' . wp_nonce_url(admin_url('admin-post.php?action=SIBA_flush_rewrite'), 'SIBA_flush') . '">فلش لینک‌ها</a>';
    $settings_link = '<a href="' . admin_url('admin.php?page=SIBAloginsignup') . '">تنظیمات</a>';
    array_unshift($links, $flush_link, $settings_link);
    return $links;
}

// تابع برای فلش کردن در صورت درخواست
add_action('admin_post_SIBA_flush_rewrite', 'SIBA_handle_flush_rewrite_request');
function SIBA_handle_flush_rewrite_request() {
    if (!current_user_can('manage_options') || !check_admin_referer('SIBA_flush')) {
        wp_die('دسترسی غیرمجاز');
    }
    SIBA_flush_rewrite_rules();
    wp_safe_redirect(admin_url('plugins.php?flushed=true'));
    exit;
}

// نمایش پیام موفقیت پس از فلش
add_action('admin_notices', function() {
    if (isset($_GET['flushed'])) {
        echo '<div class="notice notice-success is-dismissible"><p>فلش با موفقیت انجام شد و لینک‌ها بازسازی شد.</p></div>';
    }
});






add_action('wp_footer', 'siba_custom_js_action', 100);

function siba_custom_js_action() {
    $time = get_option('SIBA_login_expire'); 

    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        const countdownSeconds = <?php echo intval($time); ?>;

        function formatTime(seconds) {
            const mins = String(Math.floor(seconds / 60)).padStart(2, '0');
            const secs = String(seconds % 60).padStart(2, '0');
            return `${mins}:${secs}`;
        }

        document.querySelectorAll('.SIBA-resendbox').forEach(function (resendBox) {
            resendBox.addEventListener('click', function () {
                const countdown = document.querySelector('.SIBA-countdown');
                if (countdown) {
                    countdown.textContent = formatTime(countdownSeconds);
                }
                resendBox.classList.remove('active');
            });
        });
    });
    </script>
    <?php
}

