<?php
/**
 * Developer : MahdiY
 * Web Site  : MahdiY.IR
 * E-Mail    : M@hdiY.IR
 */

function PWS_get_states(): array {
	return [
		'AW' => 'آذربایجان غربی',
		'AE' => 'آذربایجان شرقی',
		'IS' => 'اصفهان',
		'AL' => 'البرز',
		'TE' => 'تهران',
		'KV' => 'خراسان رضوی',
		'KZ' => 'خوزستان',
		'FA' => 'فارس',
		'MN' => 'مازندران',
		'ZA' => 'زنجان',
		'AR' => 'اردبیل',
		'IL' => 'ایلام',
		'BU' => 'بوشهر',
		'CM' => 'چهار محال بختیاری',
		'KS' => 'خراسان شمالی',
		'KJ' => 'خراسان جنوبی',
		'SM' => 'سمنان',
		'SB' => 'سیستان و بلوچستان',
		'QZ' => 'قزوین',
		'QM' => 'قم',
		'KD' => 'کردستان',
		'KE' => 'کرمان',
		'BK' => 'کرمانشاه',
		'KB' => 'کهگیلویه و بویراحمد',
		'GO' => 'گلستان',
		'GI' => 'گیلان',
		'LO' => 'لرستان',
		'MK' => 'مرکزی',
		'HG' => 'هرمزگان',
		'HD' => 'همدان',
		'YA' => 'یزد',
	];
}

function PWS_get_state_city( $state ): array {
	$states_city = [
		'AR' => [
			'اردبیل',
			'اردیموسی',
			'اسلام اباد',
			'اصلاندوز',
			'النی',
			'اندبیل',
			'آبی‌بیگلو',
			'آراللو',
			'بیله‌سوار',
			'پارس‌آباد',
			'تازه کندانگوت',
			'ثمرین',
			'جعفرآباد',
			'جنگل فندقلو',
			'خلخال',
			'رضی',
			'زهرا',
			'سرعین',
			'عنبران',
			'فخراباد',
			'قصابه',
			'کلور',
			'کوراییم',
			'گرمی',
			'گیلوان',
			'گیوی',
			'لاهرود',
			'مرادلو',
			'مشگین‌شهر',
			'مغان سر',
			'نمین',
			'نیر',
			'هشتجین',
			'هیر',
		],
		'IS' => [
			'ابریشم',
			'ابوزیدآباد',
			'اردستان',
			'اژیه',
			'اصغرآباد',
			'اصفهان',
			'افوس',
			'انارک',
			'ایمانشهر',
			'آبچوئیه',
			'آران و بیدگل',
			'بادرود',
			'باغ بهادران',
			'باغشاد',
			'بافران',
			'برزک',
			'برف‌انبار',
			'بهاران شهر',
			'بهارستان',
			'بویین ومیاندشت',
			'بیده',
			'پیربکران',
			'تودشک',
			'تیران',
			'جندق',
			'جوزدان',
			'جوشقان قالی',
			'جوشقان و کامو',
			'چادگان',
			'چرمهین',
			'چمگردان',
			'حبیب آباد',
			'حسن اباد',
			'حنا',
			'خالدآباد',
			'خمینی‌شهر',
			'خوانسار',
			'خور',
			'خوراسگان',
			'خورزوق',
			'داران',
			'دامنه',
			'درچه',
			'دستگرد',
			'ده سرخ',
			'دهاقان',
			'دهق',
			'دولت آباد',
			'دیزیچه',
			'رزوه',
			'رضوانشهر',
			'زازران',
			'زاغل',
			'زاینده رود',
			'زرین‌شهر',
			'زواره',
			'زیار',
			'زیباشهر',
			'سجزی',
			'سده لنجان',
			'سفیدشهر',
			'سمیرم',
			'سین',
			'شاپورآباد',
			'شاهین‌شهر',
			'شهرضا',
			'طالخونچه',
			'طرق رود',
			'عسگران',
			'علویجه',
			'فتح آباد',
			'فرخی',
			'فریدون‌شهر',
			'فلاورجان',
			'فولادشهر',
			'قمصر',
			'قهجاورستان',
			'قهدریجان',
			'کاشان',
			'کامو و چوگان',
			'کرکوند',
			'کلیشادوسودرجان',
			'کمشجه',
			'کمه',
			'کهریزسنگ',
			'کوشک',
			'کوهپایه',
			'گرگاب',
			'گزبرخوار',
			'گلپایگان',
			'گل‌دشت',
			'گلشن',
			'گل‌شهر',
			'گوگد',
			'لای بید',
			'مبارکه',
			'مجلسی',
			'محمد آباد',
			'مشکات',
			'منظریه',
			'مهاباد',
			'میمه',
			'نایین',
			'نجف‌آباد',
			'نصرآباد',
			'نطنز',
			'نوش‌آباد',
			'نیاسر',
			'نیک‌آباد',
			'هرند',
			'ورزنه',
			'ورنامخواست',
			'وزوان',
			'ونک',
		],
		'AL' => [
			'اشتهارد',
			'آسارا',
			'پلنگ آباد',
			'تنکمان',
			'چهارباغ',
			'ساوجبلاغ',
			'شهرجدیدهشتگرد',
			'طالقان',
			'فردیس',
			'کرج',
			'کمالشهر',
			'کوهسار',
			'گرمدره',
			'گلسار',
			'ماهدشت',
			'محمدشهر',
			'مشکین‌دشت',
			'نظرآباد',
			'هشتگرد',
		],
		'IL' => [
			'ارکواز',
			'ایلام',
			'ایوان',
			'آبدانان',
			'آسمان آباد',
			'بدره',
			'بلاوه',
			'پهله',
			'توحید',
			'جعفراباد',
			'چشمه شیرین',
			'چوار',
			'دره شهر',
			'دلگشا',
			'دهلران',
			'زرنه',
			'سراب باغ',
			'سرابله',
			'شباب',
			'صالح آباد',
			'لومار',
			'ماژین',
			'مهر',
			'مهران',
			'مورموری',
			'موسیان',
			'میمه',
		],
		'AE' => [
			'اربطان',
			'اسکو',
			'اهر',
			'ایلخچی',
			'آبش‌احمد',
			'آچاچی',
			'آذرشهر',
			'آقکند',
			'باسمنج',
			'بخشایش',
			'بستان‌آباد',
			'بناب',
			'بناب مرند',
			'تبریز',
			'ترک',
			'ترکمانچای',
			'تسوج',
			'تیکمه‌داش',
			'تیمورلو',
			'جلفا',
			'جوان قلعه',
			'چاراویماق',
			'خاروانا',
			'خامنه',
			'خداجو(خراجو)',
			'خراجو',
			'خسروشهر',
			'خمارلو',
			'خواجه',
			'خوشه مهر',
			'داریان',
			'دوزدوزان',
			'ذوالبین',
			'زرنق',
			'زنوز',
			'سراب',
			'سردرود',
			'سهند',
			'سیس',
			'سیه رود',
			'شبستر',
			'شربیان',
			'شرفخانه',
			'شندآباد',
			'صوفیان',
			'عاشقلو',
			'عجب‌شیر',
			'علیشاه',
			'قره‌آغاج',
			'کُشکسرای',
			'کلوانق',
			'کلیبر',
			'کوزه‌کنان',
			'گوگان',
			'لاریجان',
			'لیلان',
			'مبارک شهر',
			'مراغه',
			'مرند',
			'ملکان',
			'ممقان',
			'مهربان',
			'میانه',
			'نظرکهریزی',
			'هادیشهر',
			'هریس',
			'هشترود',
			'هوراند',
			'وایقان',
			'ورزقان',
			'یامچی',
		],
		'AW' => [
			'ارومیه',
			'اشنویه',
			'ایواوغلی',
			'آواجیق',
			'باروق',
			'بازرگان',
			'بوکان',
			'پلدشت',
			'تکاب',
			'چایپاره',
			'خوی',
			'سردشت',
			'سرو',
			'سلماس',
			'سیلوانه',
			'سیمینه',
			'سیه‌چشمه',
			'شاهین‌دژ',
			'شوط',
			'فیرورق',
			'قره ضیاءالدین',
			'کشاورز',
			'گردکشانه',
			'ماکو',
			'محمدیار',
			'محمودآباد',
			'مهاباد',
			'میاندوآب',
			'میرآباد',
			'نالوس',
			'نقده',
			'نوشین‌شهر',
			'پیرانشهر',
			'تازه شهر',
			'تازه کندنصرت آباد',
			'چهاربرج',
			'حاجیلار',
			'خلیفان',
			'دیزج دیز',
			'ربط',
			'زرآباد',
			'قطور',
			'قوشچی',
			'گوگ تپه',
			'لاجان',
			'مرگنلر',
			'نازک علیا',
			'نلاس',
			'نوشین',
			'یولاگلدی',
		],
		'BU' => [
			'امام حسن',
			'اهرم',
			'آب‌پخش',
			'آبدان',
			'برازجان',
			'بردخون',
			'بردستان',
			'بندر دیر',
			'بندر دیلم',
			'بندر ریگ',
			'بندر کنگان',
			'بندر گناوه',
			'بنک',
			'تنگ ارم',
			'جم',
			'چغادک',
			'خارک',
			'خورموج',
			'دالکی',
			'دلوار',
			'ریز',
			'سعدآباد',
			'شبانکاره',
			'شنبه',
			'طاهری',
			'عسلویه',
			'کاکی',
			'کلمه',
			'نخل تقی',
			'وحدتیه',
			'انارستان',
			'آباد',
			'بادوله',
			'بوشکان',
			'بندر بوشهر',
			'چاه مبارک',
			'دوراهک',
			'سیراف',
			'عالی شهر',
		],
		'TE' => [
			'ارجمند',
			'اسلام‌شهر',
			'اندیشه',
			'آبعلی',
			'باغستان',
			'باقرشهر',
			'پاکدشت',
			'پردیس (شهر)',
			'پیشوا',
			'تهران',
			'دربندسر',
			'دماوند',
			'رباط‌کریم',
			'رودهن',
			'ری',
			'زردبند',
			'شاهدشهر',
			'شریف‌آباد',
			'شمیرانات',
			'شهریار',
			'صالح‌آباد',
			'صباشهر',
			'فردوسیه',
			'فشم',
			'فیروزکوه',
			'قدس',
			'قرچک',
			'کیلان',
			'گلستان',
			'لواسان',
			'ملارد',
			'نسیم‌شهر',
			'نصیرشهر',
			'وحیدیه',
			'ورامین',
			'احمد آباد مستوفی',
			'آبسرد',
			'بومهن',
			'پرند',
			'تجریش',
			'جوادآباد',
			'چهاردانگه',
			'حسن آباد',
			'شمشک',
			'صالحیه',
			'صفادشت',
			'فرون اباد',
			'قلعه نو',
			'قیام دشت',
			'کهریزک',
		],
		'CM' => [
			'اردل',
			'آلونی',
			'بروجن',
			'بلداجی',
			'جونقان',
			'چلگرد',
			'سامان',
			'سفیددشت',
			'سودجان',
			'سورشجان',
			'شلمزار',
			'شهرکرد',
			'فارسان',
			'فرادنبه',
			'فرخ‌شهر',
			'گندمان',
			'گهرو',
			'لردگان',
			'ناغان',
			'نافچ',
			'هفشجان',
			'باباحیدر',
			'بازفت',
			'بن',
			'پردنجان',
			'چلیچه',
			'دستنا',
			'دشتک',
			'سرخون',
			'سردشت',
			'صمصامی',
			'طاقانک',
			'فیل اباد',
			'کاج',
			'کیان',
			'گوجان',
			'مال خلیفه',
			'منج',
			'نقنه',
			'هارونی',
			'هوره',
			'وردنجان',
			'یان چشمه',
		],
		'KJ' => [
			'اسفدن',
			'اسلامیه',
			'آیَسک',
			'بشرویه',
			'بیرجند',
			'خضری دشت بیاض',
			'درمیان',
			'سرایان',
			'سربیشه',
			'شوسف',
			'طارق',
			'فردوس',
			'قائنات',
			'نهبندان',
			'ارسک',
			'اسدیه',
			'آبیز',
			'آرین شهر',
			'حاجی آباد',
			'درح',
			'دیهوک',
			'زهان',
			'سه قلعه',
			'طبس',
			'طبس مسینا',
			'عشق آباد',
			'قهستان',
			'گزیک',
			'محمدشهر',
			'مود',
			'نیمبلوک',
		],
		'KV' => [
			'انابد',
			'باجگیران',
			'باخرز',
			'بایگ',
			'بجستان',
			'بردسکن',
			'بیدخت',
			'تایباد',
			'تربت جام',
			'تربت حیدریه',
			'چاپشلو',
			'چکنه',
			'چناران',
			'خرو',
			'خلیل‌آباد',
			'داورزن',
			'دررود',
			'دولت‌آباد',
			'رودآب',
			'سبزوار',
			'سرخس',
			'سلامی',
			'شادمهر',
			'شاندیز',
			'طرقبه',
			'عشق آباد',
			'فرهادگرد',
			'فریمان',
			'فیروزه',
			'فیض‌آباد',
			'قاسم‌آباد',
			'قدمگاه',
			'قوچان',
			'کاخک',
			'کاریز',
			'کاشمر',
			'کلات',
			'گناباد',
			'مشهد مقدس',
			'نصرآباد',
			'نوخندان',
			'نیشابور',
			'نیل‌شهر',
			'همت آباد',
			'احمدابادصولت',
			'بار',
			'جغتای',
			'جنگل',
			'چخماق',
			'حکم اباد',
			'خواف',
			'درگز',
			'رباط سنگ',
			'رشتخوار',
			'رضویه',
			'ریواده',
			'ریوش',
			'سفیدسنگ',
			'سلطان آباد',
			'سمیع آباد',
			'سنگان',
			'ششتمد',
			'شهراباد',
			'شهرزو',
			'صالح آباد',
			'قلعه نوعلیا',
			'کدکن',
			'کندر',
			'گلبهار',
			'گلمکان',
			'لطف آباد',
			'مزدآوند',
			'مشکان',
			'ملک آباد',
			'نشتیفان',
			'نقاب',
			'یونسی',
		],
		'KS' => [
			'اسفراین',
			'آشخانه',
			'بجنورد',
			'پیش‌قلعه',
			'حصار گرم‌خان',
			'درق',
			'راز',
			'سنخواست',
			'شیروان',
			'صفی‌آباد',
			'لوجلی',
			'ایور',
			'آوا',
			'تیتکانلو',
			'جاجرم',
			'چناران شهر',
			'زیارت',
			'شوقان',
			'غلامان',
			'فاروج',
			'قاضی',
			'قوشخانه',
			'گرمه',
			'یکه سعود',
		],
		'KZ' => [
			'اروندکنار',
			'امیدیه',
			'اندیمشک',
			'آبژدان',
			'حمیدیه',
			'اهواز',
			'ایذه',
			'آبادان',
			'باغ‌ملک',
			'بندر امام خمینی ره',
			'بهبهان',
			'چمران',
			'حر ریاحی',
			'خرمشهر',
			'دزفول',
			'دشت آزادگان',
			'رامهرمز',
			'سوسنگرد',
			'شادگان',
			'شوش',
			'شوشتر',
			'صیدون',
			'گتوند',
			'لالی',
			'ماهشهر',
			'مسجد سلیمان',
			'میانرود',
			'مینوشهر',
			'هفتگل',
			'هندیجان',
			'ابوحمیظه',
			'الهایی',
			'الوان',
			'آزادی',
			'آغاجاری',
			'بستان',
			'بیدروبه',
			'ترکالکی',
			'تشان',
			'جایزان',
			'جنت مکان',
			'جولکی',
			'چغامیش',
			'چم گلک',
			'چویبده',
			'حسینیه',
			'حمزه',
			'خنافره',
			'دارخوین',
			'دهدز',
			'رامشیر',
			'رفیع',
			'رود زرد ماشین',
			'زاووت',
			'زهره',
			'سالند',
			'سرداران',
			'سردشت',
			'سلطان آباد',
			'سماله',
			'سیاه منصور',
			'شاوور',
			'شرافت',
			'شمس آباد',
			'شهر امام',
			'شهیون',
			'شیبان',
			'صالح شهر',
			'صفی آباد',
			'عرب حسن',
			'عنبر',
			'فتح المبین',
			'قلعه تل',
			'قلعه خواجه',
			'کوت سیدنعیم',
			'کوت عبداله',
			'گلگیر',
			'گوریه',
			'مشراگه',
			'مقاومت',
			'ملاثانی',
			'منتظران',
			'منصوریه',
			'میداود',
			'میانکوه',
			'هویزه',
			'ویس',
		],
		'ZA' => [
			'ارمغان‌خانه',
			'آب‌بر',
			'خرمدره',
			'زنجان',
			'سجاس',
			'سهرورد',
			'قیدار',
			'ماه‌نشان',
			'ابهر',
			'چورزق',
			'حلب',
			'دندی',
			'زرین آباد',
			'زرین رود',
			'سلطانیه',
			'صایین قلعه',
			'کرسف',
			'گرماب',
			'نوربهار',
			'نیک پی',
			'هیدج',
		],
		'SM' => [
			'ایوانکی',
			'آرادان',
			'بسطام',
			'دامغان',
			'درجزین',
			'سرخه',
			'سمنان',
			'شاهرود',
			'شهمیرزاد',
			'کلاته خیج',
			'گرمسار',
			'مجن',
			'مهدی‌شهر',
			'امیریه',
			'بیارجمند',
			'دیباج',
			'رودیان',
			'کلاته',
			'کهن آباد',
			'میامی',
		],
		'SB' => [
			'ادیمی',
			'اسپکه',
			'ایرانشهر',
			'بزمان',
			'بمپور',
			'بنت',
			'بنجار',
			'پیشین',
			'جالق',
			'چابهار',
			'خاش',
			'دوست‌محمد',
			'راسک',
			'زابل',
			'زابلی',
			'زاهدان',
			'زهک',
			'سراوان',
			'سرباز',
			'سوران',
			'فنوج',
			'قصرقند',
			'کنارک',
			'گلمورتی',
			'محمدآباد',
			'میرجاوه',
			'نصرت‌آباد',
			'نگور',
			'نوک‌آباد',
			'نیک‌شهر',
			'اسماعیل آباد',
			'آشار',
			'پارود',
			'پلان',
			'جزینک',
			'چگرد',
			'ده رییس',
			'ریگ ملک',
			'زرآباد',
			'ساربوک',
			'سرجنگل',
			'سیرکان',
			'علی اکبر',
			'قرقری',
			'گتیج',
			'گشت',
			'محمدان',
			'محمدی',
			'مهرستان',
			'هیدوچ',
		],
		'FA' => [
			'اَهِل',
			'اِوَز',
			'اردکان',
			'ارسنجان',
			'استهبان',
			'اشکنان',
			'اقلید',
			'ایزدخواست',
			'آباده',
			'باب انار',
			'بالاده',
			'بنارویه',
			'بهمن',
			'بیرم',
			'جنت‌شهر',
			'جهرم',
			'دهرم',
			'خاوران',
			'خرامه',
			'خشت',
			'خور',
			'خومه‌زار',
			'رستم',
			'سلطان شهر',
			'سورمق',
			'سوریان',
			'ششده',
			'شهر خنج',
			'شیراز',
			'صغاد',
			'صفاشهر',
			'علامرودشت',
			'فسا',
			'فیروزآباد',
			'قائمیه',
			'قطب‌آباد',
			'قیر',
			'کَوار',
			'کازرون',
			'کامفیروز',
			'کنارتخته',
			'گراش',
			'گله‌دار',
			'لار',
			'لامرد',
			'مُهر',
			'مرکزی گراش',
			'مرودشت',
			'میمند',
			'نودان',
			'نورآباد ممسنی',
			'نی‌ریز',
			'وراوی',
			'ارد',
			'اسیر',
			'افزر',
			'امام شهر',
			'ایج',
			'آباده طشک',
			'بابامنیر',
			'بوانات',
			'بیضا',
			'جویم',
			'چاه ورز',
			'حاجی آباد',
			'حسامی',
			'حسن اباد',
			'خانه زنیان',
			'خانیمن',
			'خوزی',
			'خیراباد',
			'داراب',
			'داریان',
			'دبیران',
			'دژکرد',
			'دهکویه',
			'دوبرجی',
			'دوزه',
			'رامجرد',
			'رستاق',
			'رونیز',
			'زاهدشهر',
			'زرقان',
			'زنگی اباد',
			'سده',
			'سروستان',
			'سعادت شهر',
			'سیدان',
			'شهرپیر',
			'شهرصدرا',
			'طسوج',
			'عماد شهر',
			'فاروق',
			'فال',
			'فدامی',
			'فراشبند',
			'قادراباد',
			'قره بلاغ',
			'قطرویه',
			'کارزین (فتح آباد)',
			'کره ای',
			'کوپن',
			'کوهنجان',
			'لپویی',
			'لطیفی',
			'مادرسلیمان',
			'مبارک آباددیز',
			'محمله',
			'مزایجان',
			'مشکان',
			'مصیری',
			'معزابادجابری',
			'میانشهر',
			'نوبندگان',
			'نوجین',
			'هماشهر',
		],
		'QZ' => [
			'ارداق',
			'اسفرورین',
			'اقبالیه',
			'البرز',
			'الوند',
			'آبگرم',
			'آوج',
			'بوئین زهرا',
			'بیدستان',
			'تاکستان',
			'خرمدشت',
			'دانسفهان',
			'رازمیان',
			'سگزآباد',
			'سیردان',
			'شال',
			'شریفیه',
			'ضیاآباد',
			'قزوین',
			'محمدیه',
			'محمود آباد نمونه',
			'نرجه',
			'آبیک',
			'خاکعلی',
			'کوهین',
			'معلم کلایه',
		],
		'QM' => [
			'دستجرد',
			'قم',
			'قنوات',
			'جعفریه',
			'کهک',
			'دستجرد',
			'سلفچگان',
		],
		'KD' => [
			'بابارشانی',
			'بانه',
			'بیجار',
			'چناره',
			'دهگلان',
			'زرینه',
			'سریش آباد',
			'سقز',
			'سنندج',
			'شویشه',
			'صاحب',
			'قروه',
			'مریوان',
			'اورامان تخت',
			'آرمرده',
			'برده رشه',
			'بلبان آباد',
			'بویین سفلی',
			'پیرتاج',
			'توپ آغاج',
			'حسین آباد',
			'دزج',
			'دلبران',
			'دیواندره',
			'سروآباد',
			'سنته',
			'کامیاران',
			'کانی دینار',
			'کانی سور',
			'موچش',
			'هزارکانیان',
			'یاسوکند',
		],
		'KE' => [
			'اختیارآباد',
			'امین‌شهر',
			'اندوهجرد',
			'باغین',
			'بافت',
			'بردسیر',
			'بروات',
			'بزنجان',
			'بم',
			'بهرمان',
			'پاریز',
			'جبالبارز',
			'جوپار',
			'جیرفت',
			'چترود',
			'دهج',
			'رابر',
			'راور',
			'راین',
			'رفسنجان',
			'ریحان‌شهر',
			'زنگی‌آباد',
			'زیدآباد',
			'سیرجان',
			'شهداد',
			'صفائیه',
			'فهرج',
			'کاظم‌آباد',
			'کرمان',
			'کوهبنان',
			'گلزار',
			'محی‌آباد',
			'مردهک',
			'منوجان',
			'نرماشیر',
			'نظام‌شهر',
			'نودژ',
			'یزدان‌شهر',
			'ارزوییه',
			'انار',
			'بلورد',
			'بلوک',
			'جوادیه الهیه',
			'جوزم',
			'چاه دادخدا',
			'خاتون اباد',
			'خانوک',
			'خواجو شهر',
			'خورسند',
			'درب بهشت',
			'دشتکار',
			'ده کهان',
			'دوساری',
			'رمشک',
			'رودبار',
			'زرند',
			'زهکلوت',
			'سیریز',
			'شهربابک',
			'علی اباد',
			'عنبرآباد',
			'فاریاب',
			'قلعه گنج',
			'کشکوییه',
			'کهنوج',
			'کیانشهر',
			'گلباف',
			'گنبکی',
			'لاله زار',
			'ماهان',
			'محمدآباد',
			'مس سرچشمه',
			'نجف شهر',
			'نگار',
			'هجدک',
			'هماشهر',
			'هنزا',
		],
		'BK' => [
			'ازگله',
			'اسلام‌آباد غرب',
			'باینگان',
			'بیستون',
			'پاوه',
			'جوانرود',
			'روانسر',
			'سرپل ذهاب',
			'سرمست',
			'سطر',
			'سنقر',
			'سومار',
			'صحنه',
			'قصر شیرین',
			'کرمانشاه',
			'کنگاور',
			'کوزران',
			'گهواره',
			'گیلانغرب',
			'میان‌راهان',
			'نوسود',
			'هرسین',
			'هلشی',
			'بانوره',
			'تازه آباد',
			'حمیل',
			'رباط',
			'ریجاب',
			'شاهو',
			'شروینه',
			'قلعه',
			'کرند',
			'گودین',
			'میرآباد',
			'نودشه',
		],
		'KB' => [
			'پاتاوه',
			'چرام',
			'چیتاب',
			'دوگنبدان',
			'دهدشت',
			'دیشموک',
			'سوق',
			'سی سخت',
			'کفشکنان',
			'گراب سفلی',
			'لنده',
			'لیکک',
			'محله چینی‌ها',
			'یاسوج',
			'باشت',
			'بوستان',
			'سرفاریاب',
			'قلعه رییسی',
			'مادوان',
			'مارگون',
		],
		'GO' => [
			'انبار آلوم',
			'اینچه‌بُرون',
			'آزادشهر',
			'آق قلا',
			'بندر ترکمن',
			'بندر گز',
			'خان‌ببین',
			'دلند',
			'سرخنکلاته',
			'سیمین‌شهر',
			'علی‌آباد کتول',
			'کردکوی',
			'کلاله',
			'گالیکش',
			'گرگان',
			'گمیشان',
			'گنبدکاووس',
			'مینودشت',
			'نگین‌شهر',
			'نوکنده',
			'تاتارعلیا',
			'جلین',
			'دوزین',
			'رامیان',
			'سنگدوین',
			'سیجوال',
			'صادق اباد',
			'فاضل آباد',
			'فراغی',
			'قرق',
			'گلیداغ',
			'مراوه',
			'مزرعه',
			'نوده خاندوز',
		],
		'GI' => [
			'احمدسرگوراب',
			'اسالم',
			'اطاقور',
			'املش',
			'آستانه اشرفیه',
			'بازارجمعه',
			'بندر انزلی',
			'بندر آستارا',
			'تالش',
			'توتکابن',
			'جیرنده',
			'چابکسر',
			'چوبر',
			'خلیفه محله',
			'رشت',
			'رضوان‌شهر',
			'رودبار',
			'رودسر',
			'رودبنه',
			'شفت',
			'شلمان',
			'دیلمان',
			'صومعه سرا',
			'فومن',
			'کوچصفهان',
			'لاهیجان',
			'لشت نشا',
			'لنگرود',
			'لوشان',
			'لوندویل',
			'لیسار',
			'مارلیک',
			'ماسال',
			'مرجغل',
			'منجیل',
			'واجارگاه',
			'هشتپر',
			'بره سر',
			'پره سر',
			'چاف و چمخاله',
			'حویق',
			'خشکبیجار',
			'خمام',
			'رانکوه',
			'رحیم آباد',
			'رستم آباد',
			'سنگر',
			'سیاهکل',
			'کلاچای',
			'کومله',
			'کیاشهر',
			'گوراب زرمیخ',
			'لولمان',
			'ماسوله',
			'ماکلوان',
		],
		'LO' => [
			'ازنا',
			'الشتر',
			'الیگودرز',
			'بروجرد',
			'پل‌دختر',
			'چالانچولان',
			'خرم‌آباد',
			'درب گنبد',
			'دورود',
			'زاغه',
			'سراب‌دوره',
			'فرزیان',
			'فیروزآباد',
			'کونانی',
			'کوهدشت',
			'گراب',
			'معمولان',
			'نورآباد',
			'ویسیان',
			'اشترینان',
			'بیران شهر',
			'چقابل',
			'چم پلک',
			'چمن سلطان',
			'سپیددشت',
			'سوری',
			'شاهپوراباد',
			'شول آباد',
			'مومن آباد',
			'هفت چشمه',
			'ونایی',
		],
		'MN' => [
			'امیرشهر',
			'ایزدشهر',
			'آلاشت',
			'آمل',
			'بابل',
			'بابلسر',
			'بلده',
			'بهشهر',
			'پل سفید',
			'تنکابن',
			'جویبار',
			'چالوس',
			'چمستان',
			'خلیل‌شهر',
			'خوش‌رودپی',
			'دابودشت',
			'رامسر',
			'رستمکلا',
			'رویان',
			'زرگرمحله',
			'ساری',
			'شیرگاه',
			'فریدون‌کنار',
			'فریم',
			'قائم‌شهر',
			'کلارآباد',
			'کلاردشت',
			'کله‌بست',
			'کوهی‌خیل',
			'کیاسر',
			'گتاب',
			'گرجی‌محله',
			'گزنک',
			'گلوگاه',
			'محمودآباد',
			'مرزن‌آباد',
			'مرزیکلا',
			'نشتارود',
			'نوشهر',
			'ارطه',
			'امامزاده عبدالله',
			'امیرکلا',
			'بابکان',
			'بهنمیر',
			'پایین هولار',
			'پول',
			'خرم آباد',
			'رینه',
			'زیرآب',
			'سرخرود',
			'سلمان شهر',
			'سورک',
			'شیرود',
			'طبقده',
			'عباس اباد',
			'فرح آباد',
			'کتالم وسادات شهر',
			'کجور',
			'کیاکلا',
			'نکا',
			'نور',
			'هادی شهر',
			'هچیرود',
		],
		'MK' => [
			'اراک',
			'انجدان',
			'آشتیان',
			'پرندک',
			'تفرش',
			'توره',
			'خمین',
			'خنداب',
			'رازقان',
			'زاویه',
			'ساوه',
			'سنجان',
			'شازند',
			'ضامنجان',
			'غرق‌آباد',
			'فرمهین',
			'قورچی‌باشی',
			'کرهرود',
			'کمیجان',
			'مأمونیه',
			'محلات',
			'نراق',
			'نوبران',
			'نیم‌ور',
			'دلیجان',
			'آستانه',
			'آوه',
			'تلخاب',
			'جاورسیان',
			'خشکرود',
			'خنجین',
			'داودآباد',
			'ساروق',
			'شهباز',
			'کارچان',
			'مهاجران',
			'میلاجرد',
			'هندودر',
		],
		'HG' => [
			'ابوموسی',
			'بستک',
			'بندر چارک',
			'بندر خمیر',
			'بندر عباس',
			'بندر لنگه',
			'پارسیان',
			'جاسک',
			'جناح',
			'حاجی‌آباد',
			'درگهان',
			'رودان',
			'سندرک',
			'سیریک',
			'شهر رویدر',
			'شهر کنگ',
			'فین',
			'قشم',
			'میناب',
			'بندزرک',
			'بالاشهر',
			'بیکاء',
			'پل',
			'تازیان پایین',
			'تخت',
			'تیرور',
			'دشتی',
			'دهبارز',
			'زیارتعلی',
			'سردشت',
			'سرگز',
			'سوزا',
			'طبل',
			'فارغان',
			'قلعه قاضی',
			'کوشکنار',
			'کیش',
			'کوهستک',
			'کوهیچ',
			'گروک',
			'گوهران',
			'لمزان',
			'لیردف',
			'هرمز',
			'هشتبندی',
			'هنگوییه',
		],
		'HD' => [
			'برزول',
			'بهار',
			'حسین آباد ناظم',
			'دانشگاه پیام نور لالجین',
			'رزن',
			'زنگنه',
			'سامن',
			'صالح‌آباد',
			'فامنین',
			'فرسفج',
			'فیروزان',
			'قهاوند',
			'کبودر آهنگ',
			'گیان',
			'لالجین',
			'ملایر',
			'مهاجران',
			'نهاوند',
			'ویژه ملایر',
			'همدان',
			'ازندریان',
			'اسدآباد',
			'اسلام شهر آق گل',
			'آجین',
			'تویسرکان',
			'جورقان',
			'جوکار',
			'دمق',
			'سرکان',
			'شیرین سو',
			'قروه درگزین',
			'کرفس',
			'گل تپه',
			'مریانج',
		],
		'YA' => [
			'اردکان',
			'بافق',
			'دیهوک',
			'فردوس',
			'مروست',
			'مهردشت',
			'میبد',
			'ندوشن',
			'یزد',
			'ابرکوه',
			'احمدآباد',
			'اشکذر',
			'بخ',
			'بفروییه',
			'بهاباد',
			'تفت',
			'حمیدیا',
			'خضرآباد',
			'زارچ',
			'شاهدیه',
			'عقدا',
			'مهریز',
			'نیر',
			'هرات',
		],
	];

	return $states_city[ $state ] ?? [];
}
