<?php
/*
Plugin Name: persian jet woodmart
Description: ترجمه پارسی اختصاصی المنتور جت از قالب وودمارت
Version: 1.2.1
Author: المنتورجت
Text Domain: Elementorjet.ir
Plugin URI: Elementorjet.ir
*/

function jet_woodmart_theme() {
    if (!(defined('JET_WOODMART_ACTIVE') && JET_WOODMART_ACTIVE === true)) {
        add_action('admin_notices', function () {
        echo '<div class="notice notice-warning"><p>🔔 نسخه اصلی <strong>قالب وودمارت</strong> یا <strong>جت وودمارت</strong> شناسایی نشد. لطفاً برای استفاده از ترجمه پارسی کامل و اختصاصی <strong>المنتورجت</strong>، نسخه اصلی قالب جت وودمارت را یک‌بار برای همیشه از <a href="https://elementorjet.ir/product/woodmart-theme/" target="_blank"><strong>این نشانی</strong></a> دانلود نمایید و لذت استفاده از <strong>قالب اورجینال وودمارت</strong> را در کنار <strong>بهترین و تخصصی‌ترین ترجمه پارسی وودمارت در ایران</strong> تجربه کنید.</p></div>';
        });
    }
}
add_action('init', 'jet_woodmart_theme');


function jet_woodmart_admin_font() { 
    $selected_font = get_option('jet_woodmart_admin_font', 'Vazir'); 

    echo '<style>
        @font-face {
            font-family: "Vazir";
            src: url("' . plugin_dir_url(__FILE__) . 'elementor-jet/assets-ej/fonts/Vazirmatn-UI-NL-Medium.woff2") format("woff2");
            font-weight: normal;
            font-style: normal;
        }
        
        @font-face {
            font-family: "Peyda";
            src: url("' . plugin_dir_url(__FILE__) . 'elementor-jet/assets-ej/fonts/PeydaWeb-Medium.woff2") format("woff2");
            font-weight: normal;
            font-style: normal;
        }
        
        @font-face {
            font-family: "Dana";
            src: url("' . plugin_dir_url(__FILE__) . 'elementor-jet/assets-ej/fonts/Dana-Medium.woff2") format("woff2");
            font-weight: normal;
            font-style: normal;
        }
        
        @font-face {
            font-family: "IRANSansX";
            src: url("' . plugin_dir_url(__FILE__) . 'elementor-jet/assets-ej/fonts/IRANSansX-Medium.woff2") format("woff2");
            font-weight: normal;
            font-style: normal;
        }
        
        @font-face {
            font-family: "IRANYekanX";
            src: url("' . plugin_dir_url(__FILE__) . 'elementor-jet/assets-ej/fonts/IRANYekanX-Medium.woff2") format("woff2");
            font-weight: normal;
            font-style: normal;
        }
        
        body, #adminmenu *, #wpbody-content, h1, h2, h3, h4, h5, h6, h7 {
            font-family: "' . esc_html($selected_font) . '", sans-serif !important;
        }
        #wpadminbar .ab-item, #wpadminbar .ab-label {
            font-family: "' . esc_html($selected_font) . '", sans-serif !important;
        }
    </style>';
}
add_action('admin_head', 'jet_woodmart_admin_font');



function jet_woodmart_register_settings() {
    register_setting('jet_woodmart_options_group', 'jet_woodmart_admin_font');
}

function jet_woodmart_add_settings_page() {
    add_options_page(
        'تنظیمات فونت پیشخوان', 
        'فونت پیشخوان', 
        'manage_options', 
        'jet-woodmart-font-settings', 
        'jet_woodmart_render_settings_page'
    );
}

function jet_woodmart_render_settings_page() {
    ?>
    <div class="wrap">
        <h1>تنظیمات فونت پنل مدیریت</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('jet_woodmart_options_group');
            do_settings_sections('jet_woodmart_options_group');
            $selected_font = get_option('jet_woodmart_admin_font', 'Vazir'); 
            ?>
            <table class="form-table">
                <tr>
                    <th scope="row">انتخاب فونت:</th>
                    <td>
                        <select name="jet_woodmart_admin_font">
                            <option value="Vazir" <?php selected($selected_font, 'Vazir'); ?>>وزیر</option>
                            <option value="Peyda" <?php selected($selected_font, 'Peyda'); ?>>پیدا</option>
                            <option value="Dana" <?php selected($selected_font, 'Dana'); ?>>دانا</option>
                            <option value="IRANSansX" <?php selected($selected_font, 'IRANSansX'); ?>>ایران سانس ایکس</option>
                            <option value="IRANYekanX" <?php selected($selected_font, 'IRANYekanX'); ?>>ایران یکان ایکس</option>
                        </select>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

add_action('admin_menu', 'jet_woodmart_add_settings_page');
add_action('admin_init', 'jet_woodmart_register_settings');


require 'elementor-jet/plugin-update-checker.php';
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

$myUpdateChecker = PucFactory::buildUpdateChecker(
  'https://3wm.ir/plugins/persian-jet-woodmart-dwfhyqw/persian-jet-woodmart.json',
	__FILE__, 
	'persian jet woodmart'
);

require 'elementor-jet/elementorjet.php';
