<?php
/*
Plugin Name: مدیریت دسترسی
Description: محدودسازی دسترسی کاربران غیرادمین به برگه‌ها، پست‌تایپ‌ها و صفحات ووکامرس — نسخه 5
Version: 5.0
Author: المنتور جت
Author URI: https://elementorjet.ir/
*/

if ( ! defined( 'ABSPATH' ) ) exit;

class ModiriatDastresiV5 {

    public function __construct() {
        add_action( 'admin_menu', [ $this, 'add_settings_page' ] );
        add_action( 'admin_init', [ $this, 'register_settings' ] );
        add_action( 'template_redirect', [ $this, 'restrict_access' ] );
    }

    public function add_settings_page() {
        add_menu_page(
            'مدیریت دسترسی',
            'مدیریت دسترسی',
            'manage_options',
            'modiriat-dastresi-v5',
            [ $this, 'settings_page_html' ],
            'dashicons-shield',
            59
        );
    }

    public function register_settings() {
        register_setting( 'md_dastresi_options', 'md_allowed_pages', [ $this, 'sanitize_ids' ] );
        register_setting( 'md_dastresi_options', 'md_allowed_post_types', [ $this, 'sanitize_texts' ] );
        register_setting( 'md_dastresi_options', 'md_wc_options', [ $this, 'sanitize_texts' ] );
        register_setting( 'md_dastresi_options', 'md_redirect_page', 'intval' );
    }

    public function sanitize_ids( $input ) {
        if ( ! is_array( $input ) ) return array();
        return array_map( 'intval', $input );
    }

    public function sanitize_texts( $input ) {
        if ( ! is_array( $input ) ) return array();
        return array_map( 'sanitize_text_field', $input );
    }

    public function settings_page_html() {
        if ( ! current_user_can( 'manage_options' ) ) return;

        $allowed_pages    = (array) get_option( 'md_allowed_pages', array() );
        $allowed_pt       = (array) get_option( 'md_allowed_post_types', array() );
        $wc_options       = (array) get_option( 'md_wc_options', array() );
        $redirect         = (int) get_option( 'md_redirect_page', 0 );

        $all_pages = get_pages();
        $post_types = get_post_types( array( 'public' => true ), 'objects' );

        ?>
        <div class="wrap">
            <h1>مدیریت دسترسی — نسخه 5</h1>
            <form method="post" action="options.php">
                <?php settings_fields( 'md_dastresi_options' ); ?>

                <h2>۱) برگه‌ها (Pages)</h2>
                <div style="background:#fff;border:1px solid #eee;padding:12px;border-radius:6px;max-height:250px;overflow:auto;">
                    <?php foreach ( $all_pages as $pg ): ?>
                        <label style="display:block;margin:4px 0;">
                            <input type="checkbox" name="md_allowed_pages[]" value="<?php echo $pg->ID; ?>" <?php checked( in_array( $pg->ID, $allowed_pages, true ) ); ?>>
                            <?php echo esc_html( $pg->post_title ); ?> (ID: <?php echo $pg->ID; ?>)
                        </label>
                    <?php endforeach; ?>
                </div>

                <h2 style="margin-top:20px">۲) پست‌تایپ‌ها (Post Types)</h2>
                <p>با تیک زدن هر مورد، همه آیتم‌های آن پست‌تایپ آزاد می‌شوند (مثلاً همه نوشته‌ها).</p>
                <div style="background:#fff;border:1px solid #eee;padding:12px;border-radius:6px">
                    <?php foreach ( $post_types as $pt_name => $pt_obj ): ?>
                        <label style="display:block;margin:4px 0;">
                            <input type="checkbox" name="md_allowed_post_types[]" value="<?php echo esc_attr( $pt_name ); ?>" <?php checked( in_array( $pt_name, $allowed_pt, true ) ); ?>>
                            <?php echo esc_html( $pt_obj->labels->name ); ?> (<?php echo $pt_name; ?>)
                        </label>
                    <?php endforeach; ?>
                </div>

                <h2 style="margin-top:20px">۳) دسترسی ووکامرس</h2>
                <div style="background:#fff;border:1px solid #eee;padding:12px;border-radius:6px">
                    <label style="display:block;margin:4px 0;">
                        <input type="checkbox" name="md_wc_options[]" value="shop" <?php checked( in_array( 'shop', $wc_options, true ) ); ?>>
                        صفحه فروشگاه (Shop)
                    </label>
                    <label style="display:block;margin:4px 0;">
                        <input type="checkbox" name="md_wc_options[]" value="product" <?php checked( in_array( 'product', $wc_options, true ) ); ?>>
                        صفحات محصولات (Single Product)
                    </label>
                    <label style="display:block;margin:4px 0;">
                        <input type="checkbox" name="md_wc_options[]" value="product_cat" <?php checked( in_array( 'product_cat', $wc_options, true ) ); ?>>
                        دسته‌بندی محصولات (Product Categories)
                    </label>
                    <label style="display:block;margin:4px 0;">
                        <input type="checkbox" name="md_wc_options[]" value="product_tag" <?php checked( in_array( 'product_tag', $wc_options, true ) ); ?>>
                        برچسب‌های محصولات (Product Tags)
                    </label>
                </div>

                <h2 style="margin-top:20px">۴) برگه ریدایرکت</h2>
                <?php wp_dropdown_pages( array(
                    'name' => 'md_redirect_page',
                    'selected' => $redirect,
                    'show_option_none' => '— پیام پیش‌فرض —'
                ) ); ?>

                <?php submit_button( 'ذخیره تنظیمات' ); ?>
            </form>
        </div>
        <?php
    }

    public function restrict_access() {
        if ( current_user_can('manage_options') ) return; // Admins always free
        if ( is_admin() ) return;

        $allowed_pages    = (array) get_option( 'md_allowed_pages', array() );
        $allowed_pt       = (array) get_option( 'md_allowed_post_types', array() );
        $wc_options       = (array) get_option( 'md_wc_options', array() );
        $redirect         = (int) get_option( 'md_redirect_page', 0 );

        if ( $redirect && is_page( $redirect ) ) return;

        // برگه‌ها
        if ( is_page() ) {
            $id = get_queried_object_id();
            if ( in_array( $id, $allowed_pages, true ) ) return;
            $this->redirect_or_die( $redirect );
        }

        // محصولات (single product)
        if ( function_exists('is_product') && is_product() ) {
            if ( in_array( 'product', $wc_options, true ) ) return;
            $this->redirect_or_die( $redirect );
        }

        // صفحه فروشگاه (shop)
        if ( function_exists('is_shop') && is_shop() ) {
            if ( in_array( 'shop', $wc_options, true ) ) return;
            $this->redirect_or_die( $redirect );
        }

        // دسته‌بندی‌ها و برچسب‌های محصول
        if ( is_tax('product_cat') ) {
            if ( in_array( 'product_cat', $wc_options, true ) ) return;
            $this->redirect_or_die( $redirect );
        }
        if ( is_tax('product_tag') ) {
            if ( in_array( 'product_tag', $wc_options, true ) ) return;
            $this->redirect_or_die( $redirect );
        }

        // سایر پست‌تایپ‌ها
        if ( is_singular() ) {
            $post = get_queried_object();
            if ( $post && in_array( $post->post_type, $allowed_pt, true ) ) return;
            $this->redirect_or_die( $redirect );
        }

        if ( is_post_type_archive() ) {
            $pt = get_query_var('post_type');
            if ( is_array($pt) ) $pt = reset($pt);
            if ( $pt && in_array( $pt, $allowed_pt, true ) ) return;
            $this->redirect_or_die( $redirect );
        }

        if ( is_home() ) {
            if ( in_array( 'post', $allowed_pt, true ) ) return;
            $this->redirect_or_die( $redirect );
        }
    }

    private function redirect_or_die( $redirect ) {
        if ( $redirect ) {
            $url = get_permalink( $redirect );
            if ( $url ) {
                wp_safe_redirect( $url );
                exit;
            }
        }
        wp_die( 'شما به این صفحه دسترسی ندارید.' );
    }
}

new ModiriatDastresiV5();
