<?php

if (!class_exists('elementorjet_Dashboard_Widget')) {
    class elementorjet_Dashboard_Widget {
        public function __construct() {
            add_action('admin_init', [$this, 'add_dashboard_widget']);
            add_action('wp_ajax_elementorjet_dashboard_widgets', [$this, 'ajax_dashboard_widgets']);
            add_action('wp_ajax_nopriv_elementorjet_dashboard_widgets', [$this, 'ajax_dashboard_widgets']);
            add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_dashboard_assets']);
        }
        public function add_dashboard_widget() {
            add_meta_box(
                'elementorjet_Dashboard_Widget',
                __('المنتورجت'),
                [$this, 'dashboard_widget_content'],
                'dashboard',
                'normal',
                'high'
            );
        }

        public function dashboard_widget_content() {
            ?>
            <div class="dashboard-widget-content">
                
                <div style=" direction: ltr; ">
                    <button class="slider-button prev" onclick="moveToPreviousSlide()">&#10094;</button>
                    <button class="slider-button next" onclick="moveToNextSlide()">&#10095;</button>
                </div>
                <div id="elementorjet_slider" class="slider" style="align-items: center;">
                    <div id="loading-message" class="loading" style=" width: 100%; ">
                        <div class="loader">ELEMENTORJET</div>
                    </div>
                </div>
            </div>

            <div class="dashboard-widget-content">
                <div style=" display: flex; ">
                    <span class="dashicons dashicons-welcome-learn-more" style=" color: #FBBC34; "></span>
                    <h3 style="padding-right: 6px; font-weight: 900;"><?php esc_html_e('آموزشگاه المنتورجت', 'elementorjet-dashboard'); ?></h3>                </div>
                <ul style=" margin: 0; ">
                <?php
                    $feed_url = 'https://elementorpage.ir/ej-feed/knowledge-feed.xml';
                    $response = wp_remote_get($feed_url);
                    if (is_wp_error($response)){
                        echo '<p>' . esc_html__('خطا در بارگزاری آموزش‌های جدید', 'elementorjet-dashboard') . '</p>';
                        return;
                    }
                    $body = wp_remote_retrieve_body($response);
                    $rss = simplexml_load_string($body);
                    if ($rss === false){
                        echo '<p>' . esc_html__('خطا در دریافت آموزش‌ها', 'elementorjet-dashboard') . '</p>';
                        return;
                    }
                    foreach ($rss->channel->item as $item){
                        $title = esc_html($item->title);
                        $link = esc_url($item->link);
                        echo "<li><a href='{$link}' target='_blank'>{$title}</a></li>";
                    }
                ?>
                </ul>
            </div>

            <hr width="100%" style=" margin-top: 14px; margin-bottom: 14px; "/>

            <div class="dashboard-widget-content">
                <div style=" display: flex; ">
                    <span class="dashicons dashicons-rss" style=" color: #FBBC34; "></span>
                    <h3 style="padding-right: 6px; font-weight: 900;"><?php esc_html_e('آخرین اخبار المنتورجت', 'elementorjet-dashboard'); ?></h3>
                </div>
                <ul style=" margin: 0; ">
                <?php
                    $feed_url = 'https://elementorpage.ir/ej-feed/news-feed.xml';
                    $response = wp_remote_get($feed_url);
                    if (is_wp_error($response)){
                        echo '<p>' . esc_html__('خطا در بارگزاری اخبار جدید', 'elementorjet-dashboard') . '</p>';
                        return;
                    }
                    $body = wp_remote_retrieve_body($response);
                    $rss = simplexml_load_string($body);
                    if ($rss === false){
                        echo '<p>' . esc_html__('خطا در دریافت اخبار', 'elementorjet-dashboard') . '</p>';
                        return;
                    }
                    foreach ($rss->channel->item as $item){
                        $title = esc_html($item->title);
                        $link = esc_url($item->link);
                        echo "<li><a href='{$link}' target='_blank'>{$title}</a></li>";
                    }
                ?>
                </ul>
            </div>

            <p class="community-events-footer">
                <?php
                    printf(
                        '<a style=" font-size: 11px; " href="https://elementorjet.ir/product-category/ej-bundles/" target="_blank">%2$s <span class="screen-reader-text"> %3$s</span><span aria-hidden="true" class="dashicons dashicons-external"></span></a>',
                        'https://elementorjet.ir/product-category/ej-bundles/',
                        __('جشنواره‌های فروش'),
                        __('(opens in a new tab)')
                    );
                ?>

                |

                <?php
                    printf(
                        '<a href="https://elementorjet.ir/product-category/prebuild-site/" target="_blank">%2$s <span class="screen-reader-text"> %3$s</span><span aria-hidden="true" class="dashicons dashicons-external"></span></a>',
                        'https://elementorjet.ir/product-category/prebuild-site/',
                        __('کیت‌های آماده'),
                        __('(opens in a new tab)')
                    );
                ?>

                |

                <?php
                    printf(
                        '<a href="https://elementorjet.ir/blog/" target="_blank">%2$s <span class="screen-reader-text"> %3$s</span><span aria-hidden="true" class="dashicons dashicons-external"></span></a>',
                        esc_url(_x('https://elementorjet.ir/blog/', 'Sponsership plans')),
                        __('آموزش وردپرس'),
                        __('(opens in a new tab)')
                    );
                ?>
            </p>

            <style>
                .slider {
                    display: flex;
                    position: relative;
                    width: 100%;
                    height: 300px;
                    max-height: 300px;
                }

                .slide {
                    min-width: 100%;
                    height: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    transition: transform 0.5s ease;
                }

                .slide img {
                    max-width: 100%;
                    max-height: 100%;
                    object-fit: contain;
                    border-radius: 8px;
                }

                .slider-button {
                    border-radius: 12px;
                    position: absolute;
                    top: 30%;
                    transform: translateY(-50%);
                    background-color: rgba(0, 0, 0, 0.5);
                    color: white;
                    border: none;
                    padding: 10px;
                    font-size: 20px;
                    cursor: pointer;
                    z-index: 10;
                }

                .prev {
                    left: 10px;
                }

                .next {
                    right: 10px;
                }

                .slider-button:hover {
                    background-color: rgba(0, 0, 0, 0.8);
                }
                
                .slider {
                    display: flex;
                    position: relative;
                    width: 100%;
                    height: 300px;
                    max-height: 300px;
                }
                .dashboard-widget-content{
                    overflow: hidden;
                }

                .slide {
                    min-width: 100%;
                    height: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    transition: transform 0.5s ease;
                }

                .slide img {
                    max-width: 100%;
                    max-height: 100%;
                    object-fit: contain;
                    border-radius: 8px;
                    background: none !important; 
                }

                #elementorjet-guide {
                    margin-bottom: 20px;
                }

                #elementorjet-guide .question {
                    font-size: 16px;
                    margin-bottom: 10px;
                }

                #elementorjet-guide ul {
                    list-style: none;
                    padding: 0;
                }

                #elementorjet-guide ul li {
                    margin: 5px 0;
                }

                #elementorjet-guide ul li a {
                    text-decoration: none;
                    color: #0073aa;
                }

                #elementorjet-guide ul li a:hover {
                    color: #005177;
                }

                .loading {
                    font-size: 18px;
                    text-align: center;
                    margin-top: 20px;
                    justify-content: center;
                    align-items: center;
                    display: block;
                }

                @keyframes animate8345 {
                    0%, 100% {
                        filter: hue-rotate(0deg);
                    }
                    50% {
                        filter: hue-rotate(360deg);
                    }
                }

                .loader {
                    color: rgb(0, 0, 0);
                    background: linear-gradient(to right, #1694E4, #FBBC34);
                    font-size: 30px;
                    -webkit-text-fill-color: transparent;
                    -webkit-background-clip: text;
                    animation: animate8345 9s linear infinite;
                    font-weight: bold;
                }
            </style>

            <script>
                let currentIndex = 0;

                function moveToNextSlide() {
                    const sliderContainer = document.getElementById('elementorjet_slider');
                    const slides = document.querySelectorAll('.slide');
                    const totalSlides = slides.length;

                    currentIndex = (currentIndex + 1) % totalSlides;
                    sliderContainer.style.transform = `translateX(${currentIndex * 100}%)`;
                }

                function moveToPreviousSlide() {
                    const sliderContainer = document.getElementById('elementorjet_slider');
                    const slides = document.querySelectorAll('.slide');
                    const totalSlides = slides.length;

                    currentIndex = (currentIndex - 1 + totalSlides) % totalSlides;
                    sliderContainer.style.transform = `translateX(${currentIndex * 100}%)`;
                }

                document.addEventListener('DOMContentLoaded', function () {
                    const loadingMessage = document.getElementById('loading-message');
                    const sliderContainer = document.getElementById('elementorjet_slider');
                    sliderContainer.style.visibility = 'visible'; // Show slider once it's loaded

                    jQuery.ajax({
                        url: ajaxurl,
                        method: 'GET',
                        data: { action: 'load_sponsors' },
                        success: function(response) {
                            const sponsors = JSON.parse(response);  // Parse as JSON
                            loadingMessage.style.display = 'none'; // Hide loading message

                            if (sponsors.error) {
                                alert(sponsors.error);
                                return;
                            }

                            if (sponsors.length === 0) {
                                sliderContainer.innerHTML = '<p>هیچ اطلاعاتی برای بارگذاری وجود ندارد</p>';
                                return;
                            }

                            sponsors.forEach(sponsor => {
                                const slide = document.createElement('div');
                                slide.classList.add('slide');
                                slide.innerHTML = `
                                    <a href="${sponsor.link}" target="_blank">
                                        <img src="${sponsor.image_url}" alt="${sponsor.image_alt}">
                                    </a>
                                `;
                                sliderContainer.appendChild(slide);
                            });

                            let autoSlideInterval = setInterval(moveToNextSlide, 5000);
                        },
                        error: function() {
                            alert('Failed to load sponsors');
                        }
                    });
                });
            </script>
            <?php
        }

        public function ajax_dashboard_widgets() {
            if (isset($_GET['widget']) && $_GET['widget'] === 'elementorjet_Dashboard_Widget') {
                $this->dashboard_widget_content();
            }
            wp_die();
        }

        public function enqueue_admin_dashboard_assets($hook) {
            if ($hook !== 'index.php') {
                return;
            }

            wp_localize_script('elementorjet-dashboard-script', 'ajaxurl', admin_url('admin-ajax.php'));
        }
    }

    if (!defined('elementorjet_DASHBOARD_WIDGET_LOADED')) {
        define('elementorjet_DASHBOARD_WIDGET_LOADED', true);
        new elementorjet_Dashboard_Widget();
    }
}

add_action('wp_ajax_load_sponsors', 'load_sponsors_from_apis');
add_action('wp_ajax_nopriv_load_sponsors', 'load_sponsors_from_apis');

if (!function_exists('load_sponsors_from_apis')) {
    function load_sponsors_from_apis() {
        $feed_url = 'https://elementorpage.ir/ej-feed/sponsors.txt';
        $response = wp_remote_get($feed_url);

        if (is_wp_error($response)) {
            echo json_encode(['error' => 'Failed to load sponsors']);
            wp_die();
        }

        $sponsors = json_decode(wp_remote_retrieve_body($response), true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            echo json_encode(['error' => 'Invalid JSON format']);
            wp_die();
        }

        echo json_encode($sponsors);
        wp_die();
    }
}
